(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    201572,       4886]
NotebookOptionsPosition[    190200,       4650]
NotebookOutlinePosition[    191859,       4696]
CellTagsIndexPosition[    191650,       4687]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["A| Useful functions", "Section",
 CellFrame->{{0.5, 3}, {3, 0.5}},
 CellChangeTimes->{{3.964147219021962*^9, 3.964147229565523*^9}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"b5dfebf7-454d-40a9-a414-29cced35b26b"],

Cell[BoxData[{
 StyleBox[
  RowBox[{"Needs", "[", "\"\<NDSolve`FEM`\>\"", "]"}], "Input"], "\[IndentingNewLine]", 
 RowBox[{"Needs", "[", "\"\<OpenCascadeLink`\>\"", "]"}]}], "Input",
 CellChangeTimes->{{3.965487828766243*^9, 3.9654878297849007`*^9}},
 CellLabel->"In[1]:=",
 CellID->2133587866,ExpressionUUID->"a79ad557-ee53-47cb-9718-f3bfd95d138b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Units", "Section",
 CellChangeTimes->{{3.9731305707788067`*^9, 
  3.9731305720677032`*^9}},ExpressionUUID->"c19addc3-2699-4eb8-87ac-\
e683ac7ec89e"],

Cell[TextData[{
 "I find the following definitions of units useful. Once run then the units \
can be assigned just by typing the abbreviation. The congruent sign is then \
used to obtain the results in the required units. Note that the FEM package \
works in SI units i.e. metres, kilograms and Pascals and units should not be \
used, within the package. If necessary use ",
 StyleBox["QuantityMagnitude", "inTextCode"],
 " to extract the number from the dimension. See Chapter 2."
}], "Text",
 CellChangeTimes->{{3.972820232704668*^9, 3.9728202887550497`*^9}, {
  3.972832458431471*^9, 3.9728324839922037`*^9}, {3.972832577678576*^9, 
  3.9728326369867573`*^9}, {3.9728326694578447`*^9, 3.9728326763457203`*^9}, {
  3.972902499055444*^9, 3.9729026446733828`*^9}, {3.972902859527457*^9, 
  3.972902926127317*^9}},ExpressionUUID->"fefd848b-2548-43e0-82ca-\
f9c128a9ba5e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"units", ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GPa", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<GigaPascals\>\""}], "]"}]}], ";", 
     RowBox[{"MPa", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<MegaPascals\>\""}], "]"}]}], ";", 
     RowBox[{"kPa", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<kiloPascals\>\""}], "]"}]}], ";", 
     RowBox[{"Pa", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<Pascals\>\""}], "]"}]}], ";", 
     RowBox[{"m", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<meter\>\""}], "]"}]}], ";", 
     RowBox[{"mm", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<millimeter\>\""}], "]"}]}], ";", 
     RowBox[{"MN", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<Meganewtons\>\""}], "]"}]}], ";", 
     RowBox[{"kN", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<kilonewton\>\""}], "]"}]}], ";", 
     RowBox[{"MJ", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<Megajoules\>\""}], "]"}]}], ";", 
     RowBox[{"kJ", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<kiloJoules\>\""}], "]"}]}], ";", 
     RowBox[{"kg", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<kilogram\>\""}], "]"}]}], ";", 
     RowBox[{"Unprotect", "[", "Congruent", "]"}], ";", 
     RowBox[{"Congruent", "/:", 
      RowBox[{"x_", "\[Congruent]", "y_"}], ":=", 
      RowBox[{"UnitConvert", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}], ";", 
     RowBox[{"Protect", "[", "Congruent", "]"}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.9626206118946247`*^9, 3.962620618524969*^9}, 
   3.962636540979307*^9, {3.962636818208417*^9, 3.962636849882018*^9}, {
   3.9626369315357656`*^9, 3.962636943711253*^9}, 3.962637010879611*^9, 
   3.962637086837044*^9, {3.964315295682755*^9, 3.964315304977186*^9}, {
   3.964315425546178*^9, 3.9643154266834393`*^9}, 3.964949202958517*^9},
 CellLabel->"In[3]:=",ExpressionUUID->"ad73b77e-42f6-4afc-88da-0ef1248dff08"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Subscripts", "Section"]], "Section",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.97283302074955*^9, 
  3.972833051288157*^9}},ExpressionUUID->"de2baf15-d953-4474-b5bc-\
7e6740b1ab52"],

Cell["\<\
Running the following, from the Notation palette will treat all subscripted \
symbols as Symbols rather than subscripts. \
\>", "Text",
 CellChangeTimes->{{3.972832766029615*^9, 3.97283291655903*^9}, 
   3.972832988061625*^9},ExpressionUUID->"15bbaf68-e48f-4efa-b171-\
6515a0f0c43a"],

Cell[BoxData[
 RowBox[{"Symbolize", "[", 
  TemplateBox[{
    SubscriptBox["_", "_"]},
   "NotationTemplateTag"], "]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.964315444296866*^9, 3.964315448570669*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"08d3a7a2-da8d-44d3-8bd4-6034fea6a39a"],

Cell["eg.", "Text",
 CellChangeTimes->{{3.972832993777856*^9, 
  3.972832994973996*^9}},ExpressionUUID->"c3e21b23-a67d-46ec-94e2-\
86bd516902ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  SubscriptBox["\[Sigma]", "xy"], "]"}]], "Input",
 CellChangeTimes->{{3.9728329399812813`*^9, 3.972832970219248*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"9c9afd85-1aaf-45f7-b8dd-9ecc31405a2a"],

Cell[BoxData["Symbol"], "Output",
 CellChangeTimes->{3.972832972334622*^9, 3.9731834362619143`*^9},
 CellLabel->
  "Out[133]=",ExpressionUUID->"5a1a4094-8113-45fa-bee7-486198fc3fc6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Markers", "Section"]], "Section",
 CellChangeTimes->{{3.963805756742537*^9, 3.963805758751861*^9}, 
   3.972731781621666*^9, 3.973130792135911*^9},
 CellTags->"markers",ExpressionUUID->"334acca0-80cd-49bf-b4f7-6ea9e2a7a4e1"],

Cell["\<\
This will present Manipulates showing Markers for most cases. Coloring faces \
and showing points.\
\>", "Text",
 CellChangeTimes->{{3.969328326674775*^9, 3.969328381828392*^9}, 
   3.972731781621746*^9, 
   3.97313079213594*^9},ExpressionUUID->"9460819b-a602-4f2a-afd8-\
848b185a3216"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"markers", "[", "mesh_", "]"}], "/;", 
   RowBox[{"ElementMeshQ", "[", "mesh", "]"}]}], ":=", "\[IndentingNewLine]", 
  
  RowBox[{"With", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"bIDs", "=", 
       RowBox[{"mesh", "[", "\"\<BoundaryElementMarkerUnion\>\"", "]"}]}], ",", 
      RowBox[{"pIDs", "=", 
       RowBox[{"mesh", "[", "\"\<PointElementMarkerUnion\>\"", "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"edgeframe", "=", 
       RowBox[{"mesh", "[", "\"\<Edgeframe\>\"", "]"}]}], ",", 
      RowBox[{"outline", "=", 
       RowBox[{"mesh", "[", 
        RowBox[{"\"\<Wireframe\>\"", "[", 
         RowBox[{"\"\<MeshElementStyle\>\"", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{"Opacity", "[", "0.2", "]"}], ",", 
            RowBox[{"FaceForm", "[", "LightBlue", "]"}], ",", 
            RowBox[{"EdgeForm", "[", "]"}]}], "]"}]}], "]"}], "]"}]}]}], 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"boundaries", ",", "points"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"boundaries", "=", 
        RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Show", "[", 
           RowBox[{"outline", ",", "edgeframe", ",", 
            RowBox[{"mesh", "[", 
             RowBox[{"\"\<Wireframe\>\"", "[", 
              RowBox[{
               RowBox[{"ElementMarker", "\[Equal]", 
                RowBox[{
                "bIDs", "\[LeftDoubleBracket]", "id", 
                 "\[RightDoubleBracket]"}]}], ",", 
               RowBox[{"\"\<MeshElementStyle\>\"", "\[Rule]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{"FaceForm", "[", "Green", "]"}], ",", 
                  RowBox[{"EdgeForm", "[", "Black", "]"}]}], "]"}]}]}], "]"}],
              "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"id", ",", "1", ",", "\"\<BID for Nuemann\>\""}], "}"}], 
            ",", "1", ",", 
            RowBox[{"Length", "[", "bIDs", "]"}], ",", "1", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}]}], "}"}], ",", 
          RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}]}], ";", 
       RowBox[{"points", "=", 
        RowBox[{"Manipulate", "[", 
         RowBox[{
          RowBox[{"Show", "[", 
           RowBox[{"outline", ",", "edgeframe", ",", 
            RowBox[{"mesh", "[", 
             RowBox[{"\"\<Wireframe\>\"", "[", 
              RowBox[{
               RowBox[{"ElementMarker", "\[Equal]", 
                RowBox[{
                "pIDs", "\[LeftDoubleBracket]", "id", 
                 "\[RightDoubleBracket]"}]}], ",", 
               
               RowBox[{"\"\<MeshElement\>\"", 
                "\[Rule]", "\"\<PointElements\>\""}], ",", 
               RowBox[{"\"\<MeshElementStyle\>\"", "\[Rule]", "Orange"}]}], 
              "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"id", ",", "1", ",", "\"\<PID for Dirichlet\>\""}], 
             "}"}], ",", "1", ",", 
            RowBox[{"Length", "[", "pIDs", "]"}], ",", "1", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}]}], "}"}], ",", 
          RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Row", "[", 
        RowBox[{"{", 
         RowBox[{"boundaries", ",", "points"}], "}"}], "]"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{
  3.973306425603183*^9, {3.973306589817052*^9, 3.973306591799268*^9}, {
   3.973306808646634*^9, 3.973306842184473*^9}, {3.973306925805648*^9, 
   3.9733069383504953`*^9}, 3.973307026908455*^9, {3.973307074708027*^9, 
   3.973307145179007*^9}, 3.973331350921391*^9, 3.973331650231018*^9, {
   3.9733317091935453`*^9, 3.973331718177196*^9}, {3.973331816046583*^9, 
   3.973331833751649*^9}, 3.973331905970764*^9, {3.97333195125147*^9, 
   3.973331961719173*^9}, {3.973332064198728*^9, 3.973332100517606*^9}, {
   3.973332142836068*^9, 3.973332163891223*^9}, {3.9733324744475193`*^9, 
   3.973332513919656*^9}, {3.973332545561*^9, 3.973332565734828*^9}, {
   3.973332635771022*^9, 3.973332636897592*^9}, {3.9733326812045393`*^9, 
   3.973332706605158*^9}, {3.973654866419486*^9, 3.9736548725119743`*^9}, {
   3.973654903874305*^9, 3.9736549194463043`*^9}, {3.9736550019002132`*^9, 
   3.973655007299779*^9}, 3.973655154400745*^9, {3.9736551879260607`*^9, 
   3.9736552395613747`*^9}, {3.973655279545567*^9, 3.9736552892027607`*^9}, {
   3.973655319765951*^9, 3.973655370651021*^9}, {3.973655615997356*^9, 
   3.9736556272952337`*^9}, 3.973655919300016*^9, {3.973767210480706*^9, 
   3.973767212551201*^9}, {3.9737678581763268`*^9, 3.973767879149721*^9}},
 CellID->234031570,ExpressionUUID->"f6be4547-729c-48f1-9f89-9542ea22e5b3"],

Cell["see also FEMDocumentation/tutorial/ElementMeshVisualization", "Text",
 CellChangeTimes->{{3.964322855092187*^9, 3.964322856650096*^9}, {
   3.964324754503582*^9, 3.964324757961299*^9}, 3.972731781621917*^9, 
   3.973130792136022*^9},ExpressionUUID->"93e71644-cb37-4b96-a486-\
40b65e7aabeb"],

Cell[CellGroupData[{

Cell["Showing individual markers", "Subsubsection",
 CellChangeTimes->{{3.9656140108679247`*^9, 3.9656140185439672`*^9}, 
   3.972731781622134*^9, 3.9731307921360893`*^9},
 CellID->1567672406,ExpressionUUID->"79ee2312-db14-4aa2-b0b9-67f804e01088"],

Cell[BoxData[
 RowBox[{
  RowBox[{"showMesh", "[", 
   RowBox[{"n_", ",", "colour_"}], "]"}], ":=", 
  RowBox[{"Show", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mesh", "[", "\"\<Edgeframe\>\"", "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"mesh", "[", 
     RowBox[{"\"\<Wireframe\>\"", "[", 
      RowBox[{
       RowBox[{"ElementMarker", "==", "n"}], ",", 
       RowBox[{"\"\<MeshElementStyle\>\"", "->", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"EdgeForm", "[", 
           RowBox[{"{", 
            RowBox[{"Thin", ",", "colour"}], "}"}], "]"}], ",", 
          RowBox[{"FaceForm", "[", "colour", "]"}]}], "]"}]}]}], "]"}], 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9656108653983927`*^9, 3.965610958919413*^9}, 
   3.9656134507661657`*^9, 3.965834020553738*^9, 3.9727317816221933`*^9, 
   3.973130792136113*^9},
 CellLabel->"In[7]:=",
 CellID->1183479497,ExpressionUUID->"20f96f47-2f82-48cb-b21c-5bbd749035a0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["To show a list of markers use", "Subsubsection",
 CellChangeTimes->{{3.965614045725368*^9, 3.965614052684053*^9}, {
   3.969328527465311*^9, 3.9693285381575127`*^9}, 3.972731781622241*^9, 
   3.9731307921361303`*^9},
 CellID->1962190520,ExpressionUUID->"9e4123e2-e226-4ab1-bd9c-9f0e798fffef"],

Cell["Show[showMesh[#, Red] & /@ {\"list of markers\"}]", "Text",
 CellChangeTimes->{{3.965614080571146*^9, 3.965614116964848*^9}, 
   3.965641620253162*^9, 3.9727317816222963`*^9, 3.973130792136157*^9},
 CellLabel->"In[68]:=",
 CellID->1033104820,ExpressionUUID->"1ad80b18-abec-4275-aee1-589e65d7517f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Boundary conditions", "Section",
 FontWeight->"Regular"]], "Section",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.964326100773308*^9, 3.9643261052182713`*^9}, {
  3.967132534949806*^9, 3.967132551134783*^9}, {3.9675964613994303`*^9, 
  3.967596467054636*^9}},
 FontWeight->"Bold",ExpressionUUID->"35d7e829-f2ab-487d-b05c-7ca72f76ead5"],

Cell[CellGroupData[{

Cell["Necessary functions", "Subsection",
 CellChangeTimes->{{3.967214034164165*^9, 3.9672140392447844`*^9}},
 CellID->52884170,ExpressionUUID->"969cc214-14dd-4791-bf85-f051962f165d"],

Cell[CellGroupData[{

Cell["Construction of the legend to go with the check plot.", "Subsubsection",
 CellChangeTimes->{{3.967214903077574*^9, 3.967214924337821*^9}},
 CellID->1913498979,ExpressionUUID->"56705a52-d115-4c28-9d19-15f4c9df5997"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"pressureLegend", "=", 
   RowBox[{"Panel", "[", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Column", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Row", "[", 
            RowBox[{"{", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<X Suction\>\"", ",", "Red"}], "]"}], "}"}], "]"}], 
           ",", 
           RowBox[{"Row", "[", 
            RowBox[{"{", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<Y Suction\>\"", ",", "Orange"}], "]"}], "}"}], 
            "]"}], ",", 
           RowBox[{"Row", "[", 
            RowBox[{"{", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<Z Suction\>\"", ",", "StandardYellow"}], "]"}], 
             "}"}], "]"}]}], "}"}], "]"}], ",", 
        RowBox[{"Column", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Row", "[", 
            RowBox[{"{", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<X Pressure\>\"", ",", "Blue"}], "]"}], "}"}], 
            "]"}], ",", 
           RowBox[{"Row", "[", 
            RowBox[{"{", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<Y Pressure\>\"", ",", "Green"}], "]"}], "}"}], 
            "]"}], ",", 
           RowBox[{"Row", "[", 
            RowBox[{"{", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<Z Pressure\>\"", ",", "Purple"}], "]"}], "}"}], 
            "]"}]}], "}"}], "]"}]}], "}"}], "}"}], "]"}], "]"}]}], 
  "\n"}]], "Input",
 CellChangeTimes->{{3.967170656041383*^9, 3.9671706560439873`*^9}, {
   3.967170690361492*^9, 3.967170692920886*^9}, {3.967170735074093*^9, 
   3.9671707582780113`*^9}, 3.9672176916240597`*^9},
 CellLabel->"In[8]:=",
 CellID->1609726228,ExpressionUUID->"e6e47453-b1f0-47e9-9631-9ca043fc9f3f"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      TagBox[GridBox[{
         {
          TemplateBox[{
            StyleBox["\"X Suction\"", 
             RGBColor[1, 0, 0], StripOnInput -> False]},
           "RowDefault"]},
         {
          TemplateBox[{
            StyleBox["\"Y Suction\"", 
             RGBColor[1, 0.5, 0], StripOnInput -> False]},
           "RowDefault"]},
         {
          TemplateBox[{
            StyleBox["\"Z Suction\"", 
             RGBColor[1, 0.75, 0], StripOnInput -> False]},
           "RowDefault"]}
        },
        DefaultBaseStyle->"Column",
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Column"], 
      TagBox[GridBox[{
         {
          TemplateBox[{
            StyleBox["\"X Pressure\"", 
             RGBColor[0, 0, 1], StripOnInput -> False]},
           "RowDefault"]},
         {
          TemplateBox[{
            StyleBox["\"Y Pressure\"", 
             RGBColor[0, 1, 0], StripOnInput -> False]},
           "RowDefault"]},
         {
          TemplateBox[{
            StyleBox["\"Z Pressure\"", 
             RGBColor[0.5, 0, 0.5], StripOnInput -> False]},
           "RowDefault"]}
        },
        DefaultBaseStyle->"Column",
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Column"]}
    },
    AutoDelete->False,
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"]]], "Output",
 CellChangeTimes->{
  3.967214169279126*^9, 3.967215639187956*^9, 3.967217317613613*^9, 
   3.967217692546856*^9, 3.9675436642852783`*^9, 3.967544405808805*^9, 
   3.967595712881997*^9, 3.967951479709497*^9, 3.967952486031206*^9, 
   3.968032442401787*^9, 3.9681147683116207`*^9, 3.968115204078038*^9, 
   3.9681153017806883`*^9, 3.968747685356485*^9, 3.9687482731841593`*^9, 
   3.9688088429029207`*^9, 3.970677134375258*^9, 3.9711427697878523`*^9, 
   3.972182170244443*^9, {3.972184769877802*^9, 3.9721847859612713`*^9}, 
   3.972208966951693*^9, {3.9722110170060167`*^9, 3.9722110457515078`*^9}, 
   3.973183436293099*^9},
 CellLabel->
  "Out[137]=",ExpressionUUID->"29b9a6eb-9089-4fba-8a3e-1d12ab9ad368"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Function to choose colour, depending on type of load.", "Subsubsection",
 CellChangeTimes->{{3.9672148609922047`*^9, 3.9672148756276417`*^9}},
 CellID->1175021703,ExpressionUUID->"9acb4e8d-c1c5-4d2d-9d98-d1cc79d55632"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "col", "]"}], ";"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->330144509,ExpressionUUID->"6f70e6db-7fca-4a77-8df5-57c6fea81ae4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"col", "[", 
   RowBox[{"u_", ",", "v_", ",", "w_"}], "]"}], ":=", 
  RowBox[{"Which", "[", "\[IndentingNewLine]", "  ", 
   RowBox[{
    RowBox[{"u", ">", "0"}], ",", "Red", ",", "\[IndentingNewLine]", "  ", 
    RowBox[{"u", "<", "0"}], ",", "Blue", ",", "\[IndentingNewLine]", "  ", 
    RowBox[{"v", ">", "0"}], ",", "Orange", ",", "\[IndentingNewLine]", "  ", 
    
    RowBox[{"v", "<", "0"}], ",", "Green", ",", "\[IndentingNewLine]", "  ", 
    RowBox[{"w", ">", "0"}], ",", "Yellow", ",", "\[IndentingNewLine]", "  ", 
    
    RowBox[{"w", "<", "0"}], ",", "Purple", ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "  ", "True", ",", "Black"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Default", " ", "color", " ", "if", " ", "no", " ", "condition", " ", 
     "is", " ", "met"}], " ", "*)"}], "\[IndentingNewLine]", "]"}]}]], "Input",\

 CellChangeTimes->{{3.96716899265654*^9, 3.96716899358738*^9}, {
   3.9671690293661346`*^9, 3.9671690391759253`*^9}, {3.967169072992743*^9, 
   3.967169101695889*^9}, {3.967169133304358*^9, 3.9671691349064713`*^9}, {
   3.967193356388246*^9, 3.967193357721434*^9}, {3.967193446195715*^9, 
   3.967193476659513*^9}, 3.967194068794828*^9, 3.9675445676779823`*^9, 
   3.967596594829301*^9},
 CellTags->"ChatGeneratedCell",
 CellLabel->"In[10]:=",
 CellID->1788502562,ExpressionUUID->"58ff7823-8985-458c-ba60-9e6d1554d2bc"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Function to plot the boundary mesh with one element plotted in the specified \
colour.\
\>", "Subsubsection",
 CellChangeTimes->{{3.9672150475181513`*^9, 3.967215092378955*^9}},
 CellID->1033952475,ExpressionUUID->"6a4a0eec-3603-415a-9c33-36008358e62a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"showMesh", "[", 
   RowBox[{"n_", ",", "colour_"}], "]"}], ":=", 
  RowBox[{"Show", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bmesh", "[", "\"\<Edgeframe\>\"", "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"bmesh", "[", 
     RowBox[{"\"\<Wireframe\>\"", "[", 
      RowBox[{
       RowBox[{"ElementMarker", "==", "n"}], ",", 
       RowBox[{"\"\<MeshElementStyle\>\"", "->", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"EdgeForm", "[", 
           RowBox[{"{", 
            RowBox[{"Thin", ",", "colour"}], "}"}], "]"}], ",", 
          RowBox[{"FaceForm", "[", "colour", "]"}]}], "]"}]}]}], "]"}], "]"}],
     ",", 
    RowBox[{"Axes", "->", "True"}], ",", 
    RowBox[{"AxesLabel", "->", 
     RowBox[{"{", 
      RowBox[{"\"\<X\>\"", ",", "\"\<Y\>\"", ",", "\"\<Z\>\""}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.967214127557846*^9, 3.967214209660397*^9}, {
   3.967214274216565*^9, 3.967214301612204*^9}, {3.967215676407153*^9, 
   3.967215677682397*^9}, {3.967217232344378*^9, 3.967217237709174*^9}, 
   3.967217295720172*^9, {3.967217328670969*^9, 3.967217338167701*^9}, 
   3.967217368620063*^9, {3.967595697975664*^9, 3.967595702789094*^9}, {
   3.967595745544232*^9, 3.967595756332253*^9}, {3.9675957935428247`*^9, 
   3.967595821593404*^9}},
 CellLabel->"In[11]:=",
 CellID->201575801,ExpressionUUID->"55efd9fa-d007-4c01-bd49-130d1dae12c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Check plot function to show loaded ElementMarkers with type of load. It calls \
showMesh.\
\>", "Subsubsection",
 CellChangeTimes->{{3.967215293840684*^9, 3.967215327590171*^9}, {
  3.967218280460444*^9, 3.967218337163991*^9}},
 CellID->1302776088,ExpressionUUID->"77137630-3612-46fd-9ee0-0c96f79301fb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"checkPlot", "[", 
    RowBox[{"pressure_", ",", "elements_"}], "]"}], ":=", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"showMesh", "[", 
          RowBox[{"#", ",", 
           RowBox[{"col", "[", 
            RowBox[{
             RowBox[{"pressure", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"pressure", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"pressure", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], "]"}], "&"}], "/@", 
        "elements"}], "]"}], ",", "pressureLegend"}], "}"}], "]"}]}], 
  "\n"}]], "Input",
 CellChangeTimes->{{3.967217775848337*^9, 3.967217775851368*^9}, {
  3.9675447697301197`*^9, 3.967544796736093*^9}},
 CellLabel->"In[12]:=",
 CellID->14446204,ExpressionUUID->"a39b8c53-2274-433a-b48f-46c144fa8757"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Working with OpenCascade", "Section",
 CellChangeTimes->{{3.969328587580834*^9, 
  3.9693285953977423`*^9}},ExpressionUUID->"212bd13d-8610-48ad-9a19-\
cc9344fcea7e"],

Cell[CellGroupData[{

Cell["Visualise an OpenCascadeShapeExpression", "Subsubsection",
 CellChangeTimes->{{3.964326117033161*^9, 
  3.9643261424496*^9}},ExpressionUUID->"8820580f-da57-4472-8aee-c11f91d4f726"],

Cell[BoxData[
 RowBox[{
  RowBox[{"visualizeOC", "[", 
   RowBox[{"oc_", ",", "edgeColour_", ",", "faceColour_"}], "]"}], ":=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"OpenCascadeShapeSurfaceMeshToBoundaryMesh", "[", "oc", "]"}], "[", 
     RowBox[{"\"\<Wireframe\>\"", "[", 
      RowBox[{"\"\<MeshElementStyle\>\"", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"EdgeForm", "[", "edgeColour", "]"}], ",", 
         RowBox[{"FaceForm", "[", "faceColour", "]"}]}], "]"}]}], "]"}], 
     "]"}], ",", 
    RowBox[{"Boxed", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<X\>\"", ",", "\"\<Y\>\"", ",", "\"\<Z\>\""}], "}"}]}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.963191714994132*^9, 3.963191728359248*^9}, {
   3.963191819211454*^9, 3.963191828205319*^9}, {3.9631928365858097`*^9, 
   3.963192866571209*^9}, {3.963192919271956*^9, 3.9631929503770237`*^9}, {
   3.963193079530949*^9, 3.9631930813572397`*^9}, {3.963221447590098*^9, 
   3.963221466921687*^9}, {3.963221498863667*^9, 3.963221502875478*^9}, {
   3.963223432305792*^9, 3.963223473977536*^9}, {3.963223518726828*^9, 
   3.963223554599208*^9}, {3.964491272245494*^9, 3.964491372849468*^9}, 
   3.9655258787777977`*^9},
 CellLabel->"In[13]:=",
 CellID->1804367117,ExpressionUUID->"e167e86b-24ce-4165-829e-76789ccf40c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Putting together a model whilst maintaining a common interface between them\
\>", "Subsubsection", "Tentative",
 CellChangeTimes->{{3.964326224153041*^9, 3.9643262754574614`*^9}},
 CellID->380012319,ExpressionUUID->"aff45c37-3b2d-4b37-901f-37db56a2e254"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ocModel", "=", 
  RowBox[{"OpenCascadeShapeUnion", "[", 
   RowBox[{"Flatten", "[", 
    RowBox[{"OpenCascadeShapeFaces", "/@", 
     RowBox[{"{", "}"}]}], "]"}], "]"}]}]], "Input", "Tentative",
 CellChangeTimes->{{3.963223305322237*^9, 3.963223315939679*^9}, {
   3.964326304464794*^9, 3.9643263467097263`*^9}, 3.969328569194255*^9},
 CellLabel->"In[14]:=",
 CellID->1911097996,ExpressionUUID->"ec975025-6c1a-43b7-8f1a-9f4d45901c23"],

Cell[BoxData[
 RowBox[{"OpenCascadeShapeUnion", "[", 
  RowBox[{"{", "}"}], "]"}]], "Output",
 CellChangeTimes->{
  3.96874768541364*^9, 3.9687482732183867`*^9, 3.968808842935753*^9, 
   3.970677134409813*^9, 3.971142769813621*^9, 3.972182170269779*^9, {
   3.972184769909758*^9, 3.9721847859902983`*^9}, 3.972208966983395*^9, {
   3.972211017046062*^9, 3.972211045783393*^9}, 3.9731834363224707`*^9},
 CellLabel->
  "Out[143]=",ExpressionUUID->"842aff80-eeef-4121-a371-6c68b96b1b29"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plotting stress and strain", "Section",
 CellChangeTimes->{{3.964342060380623*^9, 
  3.964342066748209*^9}},ExpressionUUID->"196cfdd4-feb1-4170-b349-\
33e7071ee877"],

Cell[CellGroupData[{

Cell["Calculating stresses", "Subsubsection", "Tentative",
 CellChangeTimes->{{3.96434207925421*^9, 3.9643420972963037`*^9}},
 CellID->210438518,ExpressionUUID->"87cc6f76-b076-4dee-9485-3027acaae303"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"stressStrain", "[", 
    RowBox[{"vars_", ",", "pars_", ",", "displacement_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"strains", ",", "stresses", ",", "vmStress"}], "}"}], ",", 
     RowBox[{
      RowBox[{"strains", "=", 
       RowBox[{"SolidMechanicsStrain", "[", 
        RowBox[{"vars", ",", "pars", ",", "displacement"}], "]"}]}], ";", 
      RowBox[{"stresses", "=", 
       RowBox[{"SolidMechanicsStress", "[", 
        RowBox[{"vars", ",", "pars", ",", "strains"}], "]"}]}], ";", 
      RowBox[{"vmStress", "=", 
       RowBox[{"VonMisesStress", "[", 
        RowBox[{"vars", ",", "pars", ",", "stresses"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"strains", ",", "stresses", ",", "vmStress"}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input", "Tentative",
 CellChangeTimes->{{3.9643295528402233`*^9, 3.9643295966653976`*^9}, {
   3.964329634839732*^9, 3.964329669836314*^9}, {3.9643297628989687`*^9, 
   3.964329777410001*^9}, 3.9654868389027*^9, {3.965487381248906*^9, 
   3.965487383921405*^9}, 3.9655545181614847`*^9, {3.965747072755533*^9, 
   3.965747075786344*^9}},
 CellLabel->"In[15]:=",
 CellID->85944229,ExpressionUUID->"cf007ac4-0af7-420d-ba2f-fc43b7ef1cf7"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Plotting stresses and strains (Note stressStrain must be run first)\
\>", "Subsubsection",
 CellChangeTimes->{{3.9638887170715227`*^9, 3.9638887283331547`*^9}, 
   3.964341955118647*^9, {3.964342111768126*^9, 3.96434215470269*^9}},
 CellTags->
  "stressStrain",ExpressionUUID->"b8132765-f72f-4979-a3c3-4df5e730790f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vmPlot", "[", 
   RowBox[{"mesh_", ",", "displacement_", ",", "vmStress_"}], "]"}], ":=", 
  RowBox[{"VectorDisplacementPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"displacement", ",", "vmStress"}], "}"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Element]", "mesh"}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", "\"\<TemperatureMap\>\""}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<Von Mises Stresses\>\"", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
       RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Large"}]}], "]"}]}]], "Input",
 CellChangeTimes->{3.965747302094474*^9},
 CellLabel->"In[16]:=",
 CellID->1276017516,ExpressionUUID->"42157021-6669-4361-87f8-643a438aeb1c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"plotStressStrain", "[", 
   RowBox[{
   "mesh_", ",", "displacement_", ",", "strains_", ",", "stresses_", ",", 
    "vmStress_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"stressPlot", ",", "strainPlot", ",", "vmPlot"}], "}"}], ",", 
    RowBox[{
     RowBox[{"vmPlot", "=", 
      RowBox[{"VectorDisplacementPlot3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"displacement", ",", "vmStress"}], "}"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Element]", "mesh"}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", "\"\<TemperatureMap\>\""}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Von Mises Stresses\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]}], ";", 
     RowBox[{"stressPlot", "=", 
      RowBox[{"MapThread", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Show", "[", 
          RowBox[{
           RowBox[{"mesh", "[", "\"\<Edgeframe\>\"", "]"}], ",", 
           RowBox[{"SliceContourPlot3D", "[", 
            RowBox[{"#1", ",", "mesh", ",", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Element]", 
              "mesh"}], ",", 
             RowBox[{"ColorFunction", "\[Rule]", "\"\<TemperatureMap\>\""}], ",", 
             RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], "]"}], ",", 
           RowBox[{"ImageSize", "\[Rule]", "Small"}], ",", 
           RowBox[{"PlotLabel", "\[Rule]", 
            RowBox[{"Style", "[", 
             RowBox[{"#2", ",", 
              RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
              RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
              RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}]}], "]"}], 
         "&"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Extract", "[", 
           RowBox[{"stresses", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "3"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           
           RowBox[{"\"\<Stress \[Sigma]xx\>\"", 
            ",", "\"\<Stress \[Sigma]yy\>\"", 
            ",", "\"\<Stress \[Sigma]zz\>\""}], "}"}]}], "}"}]}], "]"}]}], ";", 
     RowBox[{"strainPlot", "=", 
      RowBox[{"MapThread", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Show", "[", 
          RowBox[{
           RowBox[{"mesh", "[", "\"\<Edgeframe\>\"", "]"}], ",", 
           RowBox[{"SliceContourPlot3D", "[", 
            RowBox[{"#1", ",", "mesh", ",", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Element]", 
              "mesh"}], ",", 
             RowBox[{"ColorFunction", "\[Rule]", "\"\<TemperatureMap\>\""}], ",", 
             RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], "]"}], ",", 
           RowBox[{"ImageSize", "\[Rule]", "Small"}], ",", 
           RowBox[{"PlotLabel", "\[Rule]", 
            RowBox[{"Style", "[", 
             RowBox[{"#2", ",", 
              RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
              RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
              RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}]}], "]"}], 
         "&"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Extract", "[", 
           RowBox[{"strains", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "3"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           
           RowBox[{"\"\<Strain \[CurlyEpsilon]xx\>\"", 
            ",", "\"\<Strain \[CurlyEpsilon]yy\>\"", 
            ",", "\"\<Strain \[CurlyEpsilon]zz\>\""}], "}"}]}], "}"}]}], 
       "]"}]}], ";", 
     RowBox[{"Column", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<Stress Components: \>\"", ",", 
           RowBox[{"Spacer", "[", "20", "]"}]}], "}"}], "]"}], ",", 
        RowBox[{"Row", "[", 
         RowBox[{"stressPlot", ",", 
          RowBox[{"Spacer", "[", "10", "]"}]}], "]"}], ",", 
        RowBox[{"Spacer", "[", "20", "]"}], ",", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<Strain Components: \>\"", ",", 
           RowBox[{"Spacer", "[", "20", "]"}]}], "}"}], "]"}], ",", 
        RowBox[{"Row", "[", 
         RowBox[{"strainPlot", ",", 
          RowBox[{"Spacer", "[", "10", "]"}]}], "]"}], ",", 
        RowBox[{"Spacer", "[", "20", "]"}], ",", "vmPlot"}], "}"}], "]"}]}]}],
    "]"}]}]], "Input",
 CellChangeTimes->{{3.964340799212425*^9, 3.9643407992137547`*^9}, {
   3.9643409539566193`*^9, 3.964340985788392*^9}, {3.9643410661345263`*^9, 
   3.964341092518373*^9}, {3.964341356548078*^9, 3.9643414404631033`*^9}, 
   3.9643415153656883`*^9, {3.964341775416266*^9, 3.964341778463558*^9}, 
   3.964341814064767*^9, 3.964341859129982*^9, 3.9655740147419233`*^9, {
   3.965610034140603*^9, 3.965610035593976*^9}, {3.965610107892733*^9, 
   3.9656101091404457`*^9}, {3.965610161340969*^9, 3.9656101631705217`*^9}},
 CellLabel->"In[17]:=",
 CellID->808510932,ExpressionUUID->"1ad3d87c-6d10-49a3-9fff-e98345f3d70e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DeformationPlot", "Subsubsection",
 CellChangeTimes->{{3.963888789141226*^9, 3.9638887954103394`*^9}},
 CellTags->
  "Deformation",ExpressionUUID->"e58d3a59-ace2-41f2-8e6d-dd3a172cc15c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"plotDeformation", "[", 
   RowBox[{"mesh_", ",", "displacement_", ",", "scaleFactor_"}], "]"}], ":=", 
  
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "deformationPlot", "}"}], ",", 
    RowBox[{
     RowBox[{"ElementMeshDeformation", "[", 
      RowBox[{"mesh", ",", "displacement"}], "]"}], ";", 
     RowBox[{"deformationPlot", "=", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"mesh", "[", "\"\<Edgeframe\>\"", "]"}], ",", 
        RowBox[{
         RowBox[{"ElementMeshDeformation", "[", 
          RowBox[{"mesh", ",", "displacement", ",", 
           RowBox[{"\"\<ScalingFactor\>\"", "\[Rule]", "scaleFactor"}]}], 
          "]"}], "[", 
         RowBox[{"\"\<Wireframe\>\"", "[", 
          RowBox[{"\"\<ElementMeshDirective\>\"", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{
             RowBox[{"EdgeForm", "[", "]"}], ",", 
             RowBox[{"FaceForm", "[", "LightGray", "]"}]}], "]"}]}], "]"}], 
         "]"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Row", "[", 
            RowBox[{"{", 
             RowBox[{"\"\<Deformation \[Times] \>\"", ",", "scaleFactor"}], 
             "}"}], "]"}], ",", "\"\<Source Sans Pro\>\"", ",", "Bold", ",", 
           "16"}], "]"}]}]}], "]"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.963481202515839*^9, 3.963481249831361*^9}, {
   3.963481282467782*^9, 3.963481311331739*^9}, {3.963481343687148*^9, 
   3.963481382743129*^9}, {3.9634814279584427`*^9, 3.9634814553618517`*^9}, {
   3.963481526343525*^9, 3.963481607971634*^9}, {3.9634816726998377`*^9, 
   3.9634816895177107`*^9}, {3.963482231109432*^9, 3.96348232091228*^9}, {
   3.9634823532811832`*^9, 3.963482421709104*^9}, {3.96348273552691*^9, 
   3.963482740025792*^9}, {3.9634838275138407`*^9, 3.963483927195022*^9}, {
   3.963483971259144*^9, 3.9634839936925707`*^9}, 3.964327003830854*^9, {
   3.964327799491448*^9, 3.964327843621262*^9}, 3.965437354040086*^9},
 CellLabel->"In[18]:=",
 CellID->582074681,ExpressionUUID->"55fda59b-6656-4b67-8865-5f5163f0c2e9"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Bending Moment Diagrams",
 FontWeight->"Bold"]], "Subsection",
 CellChangeTimes->{{3.9635355424475937`*^9, 3.963535551623698*^9}},
 CellTags->
  "BendingMoment",ExpressionUUID->"39aa569a-117c-49e0-9253-d997040faa72"],

Cell[CellGroupData[{

Cell["YZ for displacements in the x direction.", "Subsubsection",
 CellChangeTimes->{{3.960260090227227*^9, 3.960260090511354*^9}, {
  3.960260207096334*^9, 3.960260208087678*^9}, {3.963328466737385*^9, 
  3.9633284946056013`*^9}, {3.96543918063186*^9, 3.965439198973864*^9}, {
  3.96543923857129*^9, 
  3.9654392764810123`*^9}},ExpressionUUID->"e256d30f-9e6a-46a3-943b-\
9a07367c593b"],

Cell["\<\
bmYZ[mesh,displacement,lx,Y,h,\[Nu],domain,contours=10,label,plotRange=\
Automatic/All]\
\>", "CodeText",
 CellChangeTimes->{{3.965439386891286*^9, 3.965439416749053*^9}},
 CellID->874332644,ExpressionUUID->"14e2872e-0778-45be-bb87-a10e4f6f116f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"bmYZ", "[", 
   RowBox[{
   "mesh_", ",", "displacement_", ",", "lx_", ",", "Y_", ",", "h_", ",", 
    "\[Nu]_", ",", "domain_", ",", "contours_", ",", "label_", ",", 
    "plotRange_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "displacementFunction", ",", "\[Kappa]x", ",", "\[Kappa]y", ",", 
      "\[Kappa]z", ",", "\[Kappa]xy", ",", "\[Kappa]yy", ",", "\[Kappa]yz", ",",
       "\[Kappa]xx", ",", "\[Kappa]zz", ",", "\[Kappa]xz", ",", 
      "flexuralRigidity", ",", "Myy", ",", "Mzz", ",", "Myz", ",", "bmYYPlot",
       ",", "bmZZPlot", ",", "bmYZPlot", ",", "eom"}], "}"}], ",", 
    RowBox[{
     RowBox[{"displacementFunction", "=", 
      RowBox[{
       RowBox[{
       "displacement", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
        "\[LeftDoubleBracket]", "0", "\[RightDoubleBracket]"}]}], ";", 
     RowBox[{"eom", "=", 
      RowBox[{"EvaluateOnElementMesh", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"{", 
             RowBox[{"y", ",", "2"}], "}"}]], 
           RowBox[{"displacementFunction", "[", 
            RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], ",", 
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"{", 
             RowBox[{"z", ",", "2"}], "}"}]], 
           RowBox[{"displacementFunction", "[", 
            RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], ",", 
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"x", ",", "z"}]], 
           RowBox[{"displacementFunction", "[", 
            RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]}], "}"}], ",", 
        "mesh"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"\[Kappa]yy", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"eom", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
         "[", 
        RowBox[{"lx", ",", "y", ",", "z"}], "]"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"\[Kappa]zz", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"eom", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
         "[", 
        RowBox[{"lx", ",", "y", ",", "z"}], "]"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"\[Kappa]yz", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"eom", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}],
         "[", 
        RowBox[{"lx", ",", "y", ",", "z"}], "]"}], "]"}]}], ";", 
     RowBox[{"flexuralRigidity", "=", 
      FractionBox[
       RowBox[{"Y", " ", 
        SuperscriptBox["h", "3"]}], 
       RowBox[{"12", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[Nu]", "2"]}], ")"}]}]]}], ";", 
     RowBox[{
      RowBox[{"Myy", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"-", "flexuralRigidity"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Kappa]yy", "[", 
           RowBox[{"x", ",", "z"}], "]"}], "+", 
          RowBox[{"\[Nu]", " ", 
           RowBox[{"\[Kappa]zz", "[", 
            RowBox[{"y", ",", "z"}], "]"}]}]}], ")"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"Mzz", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"-", "flexuralRigidity"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Kappa]zz", "[", 
           RowBox[{"x", ",", "z"}], "]"}], "+", 
          RowBox[{"\[Nu]", " ", 
           RowBox[{"\[Kappa]yy", "[", 
            RowBox[{"y", ",", "z"}], "]"}]}]}], ")"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"Myz", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"-", "flexuralRigidity"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Nu]"}], ")"}], " ", 
        RowBox[{"\[Kappa]yz", "[", 
         RowBox[{"y", ",", "z"}], "]"}]}], "]"}]}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"StringRepeat", "[", 
       RowBox[{"\"\<-\>\"", ",", "60"}], "]"}], "]"}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"Style", "[", 
       RowBox[{"label", ",", "Bold", ",", "Black", ",", "20"}], "]"}], "]"}], 
     ";", 
     RowBox[{"bmYYPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"Myy", "[", 
         RowBox[{"y", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"y", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Myy\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"bmZZPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"Mzz", "[", 
         RowBox[{"y", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"y", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Mzz\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"bmYZPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"Myz", "[", 
         RowBox[{"y", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"y", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Myz\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"{", 
       RowBox[{"bmYYPlot", ",", "bmZZPlot", ",", "bmYZPlot"}], "}"}], 
      "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9602583073147707`*^9, 3.960258337367518*^9}, 
   3.960260116964237*^9, {3.9602602159353027`*^9, 3.960260237606887*^9}, {
   3.96026030095643*^9, 3.9602604738237467`*^9}, {3.960260507990004*^9, 
   3.960260527349587*^9}, {3.9602607218109007`*^9, 3.960260774755*^9}, {
   3.960260952130186*^9, 3.9602609551379833`*^9}, {3.960261025424398*^9, 
   3.9602610256830873`*^9}, {3.960261423446232*^9, 3.960261449452973*^9}, {
   3.960262043190507*^9, 3.960262046918771*^9}, 3.960262116119886*^9, {
   3.960262255883382*^9, 3.960262261628574*^9}, {3.963451830138309*^9, 
   3.963451838999524*^9}, 3.964342543076913*^9, {3.964343126040329*^9, 
   3.964343136127865*^9}, 3.964343182996266*^9, {3.964343514433869*^9, 
   3.964343552396339*^9}, {3.9643436498673153`*^9, 3.964343659767582*^9}, 
   3.964343699269525*^9, {3.9643437332500887`*^9, 3.964343734936933*^9}, {
   3.9643439101744556`*^9, 3.964343927347765*^9}, {3.96434399487469*^9, 
   3.964344030039298*^9}, 3.9650387408430233`*^9, {3.965265367691697*^9, 
   3.965265379441134*^9}, {3.965439147187952*^9, 3.9654391717246733`*^9}, 
   3.973158799899796*^9},
 CellLabel->"In[19]:=",
 CellID->1611045504,ExpressionUUID->"178de30f-f590-4efb-82f6-37bf7b5b981b"]
}, Closed]],

Cell[CellGroupData[{

Cell["XZ for displacements in the y direction", "Subsubsection",
 CellChangeTimes->{{3.960258631026145*^9, 3.96025863292369*^9}, {
  3.963328528655552*^9, 
  3.963328542110505*^9}},ExpressionUUID->"6cee7dbf-dcd4-4b7c-b91e-\
bfc69c33a91d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"bmXZ", "[", 
   RowBox[{
   "mesh_", ",", "displacement_", ",", "ly_", ",", "Y_", ",", "h_", ",", 
    "\[Nu]_", ",", "domain_", ",", "contours_", ",", "label_", ",", 
    "plotRange_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "displacementFunction", ",", "\[Kappa]x", ",", "\[Kappa]y", ",", 
      "\[Kappa]z", ",", "\[Kappa]xy", ",", "\[Kappa]yy", ",", "\[Kappa]yz", ",",
       "\[Kappa]xx", ",", "\[Kappa]zz", ",", "\[Kappa]xz", ",", 
      "flexuralRigidity", ",", "Mxx", ",", "Mzz", ",", "Mxz", ",", "bmXXPlot",
       ",", "bmZZPlot", ",", "bmXZPlot", ",", "eom"}], "}"}], ",", 
    RowBox[{
     RowBox[{"displacementFunction", "=", 
      RowBox[{
       RowBox[{
       "displacement", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
        "\[LeftDoubleBracket]", "0", "\[RightDoubleBracket]"}]}], ";", 
     RowBox[{"eom", "=", 
      RowBox[{"EvaluateOnElementMesh", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"{", 
             RowBox[{"x", ",", "2"}], "}"}]], 
           RowBox[{"displacementFunction", "[", 
            RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], ",", 
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"{", 
             RowBox[{"z", ",", "2"}], "}"}]], 
           RowBox[{"displacementFunction", "[", 
            RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], ",", 
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"x", ",", "z"}]], 
           RowBox[{"displacementFunction", "[", 
            RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]}], "}"}], ",", 
        "mesh"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"\[Kappa]xx", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"eom", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
         "[", 
        RowBox[{"x", ",", "ly", ",", "z"}], "]"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"\[Kappa]zz", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"eom", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
         "[", 
        RowBox[{"x", ",", "ly", ",", "z"}], "]"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"\[Kappa]xz", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"eom", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}],
         "[", 
        RowBox[{"x", ",", "ly", ",", "z"}], "]"}], "]"}]}], ";", 
     RowBox[{"flexuralRigidity", "=", 
      FractionBox[
       RowBox[{"Y", " ", 
        SuperscriptBox["h", "3"]}], 
       RowBox[{"12", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[Nu]", "2"]}], ")"}]}]]}], ";", 
     RowBox[{
      RowBox[{"Mxx", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"-", "flexuralRigidity"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Kappa]xx", "[", 
           RowBox[{"x", ",", "z"}], "]"}], "+", 
          RowBox[{"\[Nu]", " ", 
           RowBox[{"\[Kappa]zz", "[", 
            RowBox[{"x", ",", "z"}], "]"}]}]}], ")"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"Mzz", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"-", "flexuralRigidity"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Kappa]zz", "[", 
           RowBox[{"x", ",", "z"}], "]"}], "+", 
          RowBox[{"\[Nu]", " ", 
           RowBox[{"\[Kappa]xx", "[", 
            RowBox[{"x", ",", "z"}], "]"}]}]}], ")"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"Mxz", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"-", "flexuralRigidity"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Nu]"}], ")"}], " ", 
        RowBox[{"\[Kappa]xz", "[", 
         RowBox[{"x", ",", "z"}], "]"}]}], "]"}]}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"StringRepeat", "[", 
       RowBox[{"\"\<-\>\"", ",", "60"}], "]"}], "]"}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"Style", "[", 
       RowBox[{"label", ",", "Bold", ",", "Black", ",", "20"}], "]"}], "]"}], 
     ";", 
     RowBox[{"bmXXPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"Mxx", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", "\"\<Mxx\>\""}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"bmZZPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"Mzz", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Mzz\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"bmXZPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"Mxz", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Mxz\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"{", 
       RowBox[{"bmXXPlot", ",", "bmZZPlot", ",", "bmXZPlot"}], "}"}], 
      "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9634518177325983`*^9, 3.963451824691877*^9}, 
   3.9643433338174458`*^9, 3.964343384468391*^9, {3.964344041292987*^9, 
   3.9643441016898413`*^9}, 3.96434416821999*^9, 3.965038747544339*^9, {
   3.965265352589082*^9, 3.965265360239648*^9}, {3.965439105626644*^9, 
   3.965439140195385*^9}, 3.9731588154916563`*^9},
 CellLabel->"In[20]:=",
 CellID->1249065613,ExpressionUUID->"255bcb21-247c-4220-8995-c31751c9e565"]
}, Closed]],

Cell[CellGroupData[{

Cell["XY for displacements in the z direction", "Subsubsection",
 CellChangeTimes->{{3.960258624327546*^9, 3.960258647099737*^9}, {
  3.9633285470738*^9, 
  3.963328558817589*^9}},ExpressionUUID->"a5d72e17-77a5-4afe-8f36-\
bf24b7d2e33a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"bmXY", "[", 
   RowBox[{
   "mesh_", ",", "displacement_", ",", "lz_", ",", "Y_", ",", "h_", ",", 
    "\[Nu]_", ",", "domain_", ",", "contours_", ",", "label_", ",", 
    "plotRange_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "displacementFunction", ",", "\[Kappa]x", ",", "\[Kappa]y", ",", 
      "\[Kappa]z", ",", "\[Kappa]xy", ",", "\[Kappa]yy", ",", "\[Kappa]yz", ",",
       "\[Kappa]xx", ",", "\[Kappa]zz", ",", "\[Kappa]xz", ",", 
      "flexuralRigidity", ",", "Mxx", ",", "Myy", ",", "Mxy", ",", "bmXXPlot",
       ",", "bmYYPlot", ",", "bmXYPlot", ",", "eom"}], "}"}], ",", 
    RowBox[{
     RowBox[{"displacementFunction", "=", 
      RowBox[{
       RowBox[{
       "displacement", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}],
        "\[LeftDoubleBracket]", "0", "\[RightDoubleBracket]"}]}], ";", 
     RowBox[{"eom", "=", 
      RowBox[{"EvaluateOnElementMesh", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"{", 
             RowBox[{"x", ",", "2"}], "}"}]], 
           RowBox[{"displacementFunction", "[", 
            RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], ",", 
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"{", 
             RowBox[{"y", ",", "2"}], "}"}]], 
           RowBox[{"displacementFunction", "[", 
            RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], ",", 
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"x", ",", "y"}]], 
           RowBox[{"displacementFunction", "[", 
            RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]}], "}"}], ",", 
        "mesh"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"\[Kappa]xx", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"eom", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
         "[", 
        RowBox[{"x", ",", "y", ",", "lz"}], "]"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"\[Kappa]yy", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"eom", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
         "[", 
        RowBox[{"x", ",", "y", ",", "lz"}], "]"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"\[Kappa]xy", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"eom", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}],
         "[", 
        RowBox[{"x", ",", "y", ",", "lz"}], "]"}], "]"}]}], ";", 
     RowBox[{"flexuralRigidity", "=", 
      FractionBox[
       RowBox[{"Y", " ", 
        SuperscriptBox["h", "3"]}], 
       RowBox[{"12", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[Nu]", "2"]}], ")"}]}]]}], ";", 
     RowBox[{
      RowBox[{"Mxx", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"-", "flexuralRigidity"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Kappa]xx", "[", 
           RowBox[{"x", ",", "y"}], "]"}], "+", 
          RowBox[{"\[Nu]", " ", 
           RowBox[{"\[Kappa]yy", "[", 
            RowBox[{"x", ",", "y"}], "]"}]}]}], ")"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"Myy", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"-", "flexuralRigidity"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Kappa]yy", "[", 
           RowBox[{"x", ",", "y"}], "]"}], "+", 
          RowBox[{"\[Nu]", " ", 
           RowBox[{"\[Kappa]xx", "[", 
            RowBox[{"x", ",", "y"}], "]"}]}]}], ")"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"Mxy", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"-", "flexuralRigidity"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Nu]"}], ")"}], " ", 
        RowBox[{"\[Kappa]xy", "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "]"}]}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"StringRepeat", "[", 
       RowBox[{"\"\<-\>\"", ",", "60"}], "]"}], "]"}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"Style", "[", 
       RowBox[{"label", ",", "Bold", ",", "Black", ",", "20"}], "]"}], "]"}], 
     ";", 
     RowBox[{"bmXXPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"Mxx", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Mxx\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"bmYYPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"Myy", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Myy\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"bmXYPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"Mxy", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Mxy\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"{", 
       RowBox[{"bmXXPlot", ",", "bmYYPlot", ",", "bmXYPlot"}], "}"}], 
      "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.960258653144884*^9, {3.9602586881807537`*^9, 3.960258828531652*^9}, {
   3.9602588667996264`*^9, 3.9602590495477047`*^9}, {3.9602600408718433`*^9, 
   3.960260041076569*^9}, {3.960261676989374*^9, 3.960261684947309*^9}, 
   3.9633303198906393`*^9, {3.9633645490336933`*^9, 3.9633645586248817`*^9}, {
   3.963451803179607*^9, 3.9634518125508738`*^9}, {3.964344114342499*^9, 
   3.964344184371451*^9}, {3.9643447877965918`*^9, 3.964344831039342*^9}, 
   3.964344975770989*^9, 3.965038756115089*^9, {3.965265314577549*^9, 
   3.965265342883308*^9}, 3.9652968142973843`*^9, {3.965439044128065*^9, 
   3.96543909496848*^9}, 3.973158826717868*^9},
 CellLabel->"In[21]:=",
 CellID->2117903545,ExpressionUUID->"7f3fbcf6-85f9-4992-b74e-2b859b6f0d4a"]
}, Closed]],

Cell[TextData[StyleBox["Bending Moment Diagrams with Wood Armer Corrections",
 FontWeight->"Bold"]], "Subsubsection",
 CellChangeTimes->{{3.963535560461649*^9, 
  3.963535574771442*^9}},ExpressionUUID->"c6ab4482-c835-4bc5-918a-\
176c4299aca0"],

Cell[CellGroupData[{

Cell["\<\
YZ for displacements in the x direction.
wabmYZ[mesh_,displacement_,lx_,Y_,h_,\[Nu]_,domain_,contours_,label_,\
plotRange_]\
\>", "Subsubsection",
 CellChangeTimes->{{3.960260090227227*^9, 3.960260090511354*^9}, {
  3.960260207096334*^9, 3.960260208087678*^9}, {3.963328466737385*^9, 
  3.9633284946056013`*^9}, {3.965439034799114*^9, 
  3.965439035316947*^9}},ExpressionUUID->"22c15839-5c7d-402d-91af-\
8b5eae579ef8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"wabmYZ", "[", 
   RowBox[{
   "mesh_", ",", "displacement_", ",", "lx_", ",", "Y_", ",", "h_", ",", 
    "\[Nu]_", ",", "domain_", ",", "contours_", ",", "label_", ",", 
    "plotRange_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "displacementFunction", ",", "\[Kappa]x", ",", "\[Kappa]y", ",", 
      "\[Kappa]z", ",", "\[Kappa]xy", ",", "\[Kappa]yy", ",", "\[Kappa]yz", ",",
       "\[Kappa]xx", ",", "\[Kappa]zz", ",", "\[Kappa]xz", ",", 
      "flexuralRigidity", ",", "Myy", ",", "Mzz", ",", "Myz", ",", "bmYYPlot",
       ",", "bmZZPlot", ",", "bmYZPlot", ",", "eom", ",", "MyyDesign", ",", 
      "MzzDesign", ",", "MyyPos", ",", "MzzPos", ",", "MyyNeg", ",", "MzzNeg",
       ",", "waMyyPosPlot", ",", "waMzzPosPlot", ",", "waMyyNegPlot", ",", 
      "waMzzNegPlot", ",", "MyyPosMax", ",", "MzzPosMax", ",", "MyyNegMax", ",",
       "MzzNegMax"}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"displacementFunction", "=", 
        RowBox[{
         RowBox[{
         "displacement", "\[LeftDoubleBracket]", "1", 
          "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "0", 
         "\[RightDoubleBracket]"}]}], ";", 
       RowBox[{"eom", "=", 
        RowBox[{"EvaluateOnElementMesh", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             SubscriptBox["\[PartialD]", 
              RowBox[{"{", 
               RowBox[{"y", ",", "2"}], "}"}]], 
             RowBox[{"displacementFunction", "[", 
              RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], ",", 
            RowBox[{
             SubscriptBox["\[PartialD]", 
              RowBox[{"{", 
               RowBox[{"z", ",", "2"}], "}"}]], 
             RowBox[{"displacementFunction", "[", 
              RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], ",", 
            RowBox[{
             SubscriptBox["\[PartialD]", 
              RowBox[{"x", ",", "z"}]], 
             RowBox[{"displacementFunction", "[", 
              RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]}], "}"}], ",", 
          "mesh"}], "]"}]}], ";", 
       RowBox[{
        RowBox[{"\[Kappa]yy", "[", 
         RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{
          "eom", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "[", 
          
          RowBox[{"lx", ",", "y", ",", "z"}], "]"}], "]"}]}], ";", 
       RowBox[{
        RowBox[{"\[Kappa]zz", "[", 
         RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{
          "eom", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "[", 
          
          RowBox[{"lx", ",", "y", ",", "z"}], "]"}], "]"}]}], ";", 
       RowBox[{
        RowBox[{"\[Kappa]yz", "[", 
         RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{
          "eom", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], "[", 
          
          RowBox[{"lx", ",", "y", ",", "z"}], "]"}], "]"}]}], ";", 
       RowBox[{"flexuralRigidity", "=", 
        FractionBox[
         RowBox[{"Y", " ", 
          SuperscriptBox["h", "3"]}], 
         RowBox[{"12", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["\[Nu]", "2"]}], ")"}]}]]}], ";", 
       RowBox[{
        RowBox[{"Myy", "[", 
         RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"-", "flexuralRigidity"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[Kappa]yy", "[", 
             RowBox[{"x", ",", "z"}], "]"}], "+", 
            RowBox[{"\[Nu]", " ", 
             RowBox[{"\[Kappa]zz", "[", 
              RowBox[{"y", ",", "z"}], "]"}]}]}], ")"}]}], "]"}]}], ";", 
       RowBox[{
        RowBox[{"Mzz", "[", 
         RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"-", "flexuralRigidity"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[Kappa]zz", "[", 
             RowBox[{"x", ",", "z"}], "]"}], "+", 
            RowBox[{"\[Nu]", " ", 
             RowBox[{"\[Kappa]yy", "[", 
              RowBox[{"y", ",", "z"}], "]"}]}]}], ")"}]}], "]"}]}], ";", 
       RowBox[{
        RowBox[{"Myz", "[", 
         RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"-", "flexuralRigidity"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Nu]"}], ")"}], " ", 
          RowBox[{"\[Kappa]yz", "[", 
           RowBox[{"y", ",", "z"}], "]"}]}], "]"}]}], ";", 
       RowBox[{"Print", "[", 
        RowBox[{"StringRepeat", "[", 
         RowBox[{"\"\<-\>\"", ",", "60"}], "]"}], "]"}], ";", 
       RowBox[{"Print", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"label", ",", "Bold", ",", "Black", ",", "20"}], "]"}], 
        "]"}], ";", 
       RowBox[{"bmYYPlot", "=", 
        RowBox[{"ContourPlot", "[", 
         RowBox[{
          RowBox[{"Myy", "[", 
           RowBox[{"y", ",", "z"}], "]"}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"y", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
          RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
          RowBox[{"PlotLabel", "\[Rule]", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<Myy\>\"", ",", 
             RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
             RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
          RowBox[{"ColorFunction", "\[Rule]", 
           RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
       RowBox[{"bmZZPlot", "=", 
        RowBox[{"ContourPlot", "[", 
         RowBox[{
          RowBox[{"Mzz", "[", 
           RowBox[{"y", ",", "z"}], "]"}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"y", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
          RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"PlotLabel", "\[Rule]", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<Mzz\>\"", ",", 
             RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
             RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
          RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
          RowBox[{"ColorFunction", "\[Rule]", 
           RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
       RowBox[{"bmYZPlot", "=", 
        RowBox[{"ContourPlot", "[", 
         RowBox[{
          RowBox[{"Myz", "[", 
           RowBox[{"y", ",", "z"}], "]"}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"y", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
          RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"PlotLabel", "\[Rule]", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<Myz\>\"", ",", 
             RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
             RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
          RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
          RowBox[{"ColorFunction", "\[Rule]", 
           RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
       RowBox[{"Print", "[", 
        RowBox[{"{", 
         RowBox[{"bmYYPlot", ",", "bmZZPlot", ",", "bmYZPlot"}], "}"}], "]"}],
        ";"}], ")"}], ";", 
     RowBox[{
      RowBox[{"MyyDesign", "[", 
       RowBox[{"y_", ",", "z_"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"Myy", "[", 
        RowBox[{"y", ",", "z"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Sign", "[", 
         RowBox[{"Myy", "[", 
          RowBox[{"y", ",", "z"}], "]"}], "]"}], " ", 
        RowBox[{"Abs", "[", 
         RowBox[{"Myz", "[", 
          RowBox[{"y", ",", "z"}], "]"}], "]"}]}]}]}], ";", 
     RowBox[{
      RowBox[{"MzzDesign", "[", 
       RowBox[{"y_", ",", "z_"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"Mzz", "[", 
        RowBox[{"y", ",", "z"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Sign", "[", 
         RowBox[{"Mzz", "[", 
          RowBox[{"y", ",", "z"}], "]"}], "]"}], " ", 
        RowBox[{"Abs", "[", 
         RowBox[{"Myz", "[", 
          RowBox[{"y", ",", "z"}], "]"}], "]"}]}]}]}], ";", 
     RowBox[{
      RowBox[{"MyyPos", "[", 
       RowBox[{"y_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Max", "[", 
       RowBox[{
        RowBox[{"MyyDesign", "[", 
         RowBox[{"y", ",", "z"}], "]"}], ",", "0"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"MzzPos", "[", 
       RowBox[{"y_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Max", "[", 
       RowBox[{
        RowBox[{"MzzDesign", "[", 
         RowBox[{"y", ",", "z"}], "]"}], ",", "0"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"MyyNeg", "[", 
       RowBox[{"y_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"MyyDesign", "[", 
         RowBox[{"y", ",", "z"}], "]"}], ",", "0"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"MzzNeg", "[", 
       RowBox[{"y_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"MzzDesign", "[", 
         RowBox[{"y", ",", "z"}], "]"}], ",", "0"}], "]"}]}], ";", 
     RowBox[{"waMyyPosPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"MyyPos", "[", 
         RowBox[{"y", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"y", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Myy WA +ve XX\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"waMzzPosPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"MyyPos", "[", 
         RowBox[{"y", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"y", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Mzz WA +ve YY\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"waMyyNegPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"MyyNeg", "[", 
         RowBox[{"y", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"y", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Myy WA Neg XX\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"waMzzNegPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"MyyNeg", "[", 
         RowBox[{"y", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"y", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Mzz WA Neg YY\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"MzzPosMax", "=", 
      RowBox[{"NMaximize", "[", 
       RowBox[{
        RowBox[{"MzzPos", "[", 
         RowBox[{"y", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"y", ",", "z"}], "}"}], "\[Element]", "domain"}]}], "]"}]}],
      ";", 
     RowBox[{"MyyPosMax", "=", 
      RowBox[{"NMaximize", "[", 
       RowBox[{
        RowBox[{"MyyPos", "[", 
         RowBox[{"y", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"y", ",", "z"}], "}"}], "\[Element]", "domain"}]}], "]"}]}],
      ";", 
     RowBox[{"MzzNegMax", "=", 
      RowBox[{"NMinimize", "[", 
       RowBox[{
        RowBox[{"MzzNeg", "[", 
         RowBox[{"y", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"y", ",", "z"}], "}"}], "\[Element]", "domain"}]}], "]"}]}],
      ";", 
     RowBox[{"MyyNegMax", "=", 
      RowBox[{"NMinimize", "[", 
       RowBox[{
        RowBox[{"MyyNeg", "[", 
         RowBox[{"y", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"y", ",", "z"}], "}"}], "\[Element]", "domain"}]}], "]"}]}],
      ";", 
     RowBox[{"Print", "[", 
      RowBox[{"{", 
       RowBox[{
       "waMyyPosPlot", ",", "waMzzPosPlot", ",", "waMyyNegPlot", ",", 
        "waMzzNegPlot"}], "}"}], "]"}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Maximum +ve Myy =\>\"", ",", "MyyPosMax", 
       ",", "\"\<  Maximum +ve Mzz =\>\"", ",", "MyyPosMax"}], "]"}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Maximum -ve Myy =\>\"", ",", "MyyNegMax", 
       ",", "\"\<  Maximum -ve Mzz =\>\"", ",", "MyyNegMax"}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9602583073147707`*^9, 3.960258337367518*^9}, 
   3.960260116964237*^9, {3.9602602159353027`*^9, 3.960260237606887*^9}, {
   3.96026030095643*^9, 3.9602604738237467`*^9}, {3.960260507990004*^9, 
   3.960260527349587*^9}, {3.9602607218109007`*^9, 3.960260774755*^9}, {
   3.960260952130186*^9, 3.9602609551379833`*^9}, {3.960261025424398*^9, 
   3.9602610256830873`*^9}, {3.960261423446232*^9, 3.960261449452973*^9}, {
   3.960262043190507*^9, 3.960262046918771*^9}, 3.960262116119886*^9, {
   3.960262255883382*^9, 3.960262261628574*^9}, {3.9633984235607777`*^9, 
   3.963398431579369*^9}, {3.9633984956304903`*^9, 3.9633985074141006`*^9}, 
   3.963398683282549*^9, {3.963398754282236*^9, 3.963398754927957*^9}, {
   3.963416414939314*^9, 3.9634164374089937`*^9}, {3.963416574286182*^9, 
   3.963416582713464*^9}, {3.963416614908082*^9, 3.963416693804246*^9}, {
   3.963416778885791*^9, 3.963416780869475*^9}, {3.963416830309661*^9, 
   3.9634168464638977`*^9}, {3.9634169018747063`*^9, 
   3.9634169061425457`*^9}, {3.963451508868587*^9, 3.963451564046607*^9}, 
   3.9634516502013483`*^9, {3.963452644084477*^9, 3.963452644458495*^9}, {
   3.9634763760065804`*^9, 3.963476412609399*^9}, {3.963476698480123*^9, 
   3.9634767251983356`*^9}, {3.963476845644589*^9, 3.963476855133013*^9}, {
   3.9634770630403833`*^9, 3.963477108594396*^9}, {3.963477161516964*^9, 
   3.9634771651297493`*^9}, {3.963477205392706*^9, 3.9634772640761538`*^9}, {
   3.963478184958659*^9, 3.9634782029130583`*^9}, {3.963478514053293*^9, 
   3.963478515717338*^9}, {3.96347870813196*^9, 3.963478750903483*^9}, {
   3.9634791876633797`*^9, 3.963479293326886*^9}, {3.9634794103723717`*^9, 
   3.96347942353113*^9}, {3.96347945996315*^9, 3.963479470616544*^9}, {
   3.963479764407134*^9, 3.963479767676058*^9}, {3.9634800526865273`*^9, 
   3.963480085544269*^9}, {3.963480177911537*^9, 3.963480202862666*^9}, {
   3.963480511767888*^9, 3.963480575405259*^9}, 3.964344619787859*^9, {
   3.96434465466846*^9, 3.96434467662932*^9}, {3.9643450977345343`*^9, 
   3.964345107617523*^9}, {3.9643451503813267`*^9, 3.964345254722041*^9}, {
   3.964345396428195*^9, 3.964345404392091*^9}, {3.96434544844562*^9, 
   3.9643455697723713`*^9}, {3.964345600595559*^9, 3.964345611704606*^9}, 
   3.964345800830303*^9, 3.965295601430893*^9, {3.965295665408235*^9, 
   3.965295705108129*^9}, {3.965438956512055*^9, 3.965439009932415*^9}, 
   3.973158838235632*^9},
 CellLabel->"In[22]:=",
 CellID->1879943605,ExpressionUUID->"e8f3eb27-5974-4148-a6bf-f000e209abe2"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
XZ for displacements in the y direction
wabmXZ[mesh_,displacement_,ly_,Y_,h_,\[Nu]_,domain_,contours_,label_,\
plotRange_]\
\>", "Subsubsection",
 CellChangeTimes->{{3.960258631026145*^9, 3.96025863292369*^9}, {
  3.963328528655552*^9, 3.963328542110505*^9}, {3.965438882218424*^9, 
  3.965438882732134*^9}},ExpressionUUID->"d5cbf7d5-f80d-4562-a9d8-\
a0c602033a32"],

Cell[BoxData[
 RowBox[{
  RowBox[{"wabmXZ", "[", 
   RowBox[{
   "mesh_", ",", "displacement_", ",", "ly_", ",", "Y_", ",", "h_", ",", 
    "\[Nu]_", ",", "domain_", ",", "contours_", ",", "label_", ",", 
    "plotRange_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "displacementFunction", ",", "\[Kappa]x", ",", "\[Kappa]y", ",", 
      "\[Kappa]z", ",", "\[Kappa]xy", ",", "\[Kappa]yy", ",", "\[Kappa]yz", ",",
       "\[Kappa]xx", ",", "\[Kappa]zz", ",", "\[Kappa]xz", ",", 
      "flexuralRigidity", ",", "Mxx", ",", "Mzz", ",", "Mxz", ",", "bmXXPlot",
       ",", "bmZZPlot", ",", "bmXZPlot", ",", "eom", ",", "MxxDesign", ",", 
      "MzzDesign", ",", "MxxPos", ",", "MzzPos", ",", "MxxNeg", ",", "MzzNeg",
       ",", "waMxxPosPlot", ",", "waMzzPosPlot", ",", "waMxxNegPlot", ",", 
      "waMzzNegPlot", ",", "MxxPosMax", ",", "MzzPosMax", ",", "MxxNegMax", ",",
       "MzzNegMax"}], "}"}], ",", 
    RowBox[{
     RowBox[{"displacementFunction", "=", 
      RowBox[{
       RowBox[{
       "displacement", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
        "\[LeftDoubleBracket]", "0", "\[RightDoubleBracket]"}]}], ";", 
     RowBox[{"eom", "=", 
      RowBox[{"EvaluateOnElementMesh", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"{", 
             RowBox[{"x", ",", "2"}], "}"}]], 
           RowBox[{"displacementFunction", "[", 
            RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], ",", 
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"{", 
             RowBox[{"z", ",", "2"}], "}"}]], 
           RowBox[{"displacementFunction", "[", 
            RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], ",", 
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"x", ",", "z"}]], 
           RowBox[{"displacementFunction", "[", 
            RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]}], "}"}], ",", 
        "mesh"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"\[Kappa]xx", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"eom", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
         "[", 
        RowBox[{"x", ",", "ly", ",", "z"}], "]"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"\[Kappa]zz", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"eom", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
         "[", 
        RowBox[{"x", ",", "ly", ",", "z"}], "]"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"\[Kappa]xz", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"eom", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}],
         "[", 
        RowBox[{"x", ",", "ly", ",", "z"}], "]"}], "]"}]}], ";", 
     RowBox[{"flexuralRigidity", "=", 
      FractionBox[
       RowBox[{"Y", " ", 
        SuperscriptBox["h", "3"]}], 
       RowBox[{"12", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[Nu]", "2"]}], ")"}]}]]}], ";", 
     RowBox[{
      RowBox[{"Mxx", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"-", "flexuralRigidity"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Kappa]xx", "[", 
           RowBox[{"x", ",", "z"}], "]"}], "+", 
          RowBox[{"\[Nu]", " ", 
           RowBox[{"\[Kappa]zz", "[", 
            RowBox[{"x", ",", "z"}], "]"}]}]}], ")"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"Mzz", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"-", "flexuralRigidity"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Kappa]zz", "[", 
           RowBox[{"x", ",", "z"}], "]"}], "+", 
          RowBox[{"\[Nu]", " ", 
           RowBox[{"\[Kappa]xx", "[", 
            RowBox[{"x", ",", "z"}], "]"}]}]}], ")"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"Mxz", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"-", "flexuralRigidity"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Nu]"}], ")"}], " ", 
        RowBox[{"\[Kappa]xz", "[", 
         RowBox[{"x", ",", "z"}], "]"}]}], "]"}]}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"StringRepeat", "[", 
       RowBox[{"\"\<-\>\"", ",", "650"}], "]"}], "]"}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"Style", "[", 
       RowBox[{"label", ",", "Bold", ",", "Black", ",", "20"}], "]"}], "]"}], 
     ";", 
     RowBox[{"bmXXPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"Mxx", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Mxx\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"bmZZPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"Mzz", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Mzz\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"bmXZPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"Mxz", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Mxz\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"{", 
       RowBox[{"bmXXPlot", ",", "bmZZPlot", ",", "bmXZPlot"}], "}"}], "]"}], 
     ";", 
     RowBox[{"Print", "[", 
      RowBox[{"StringRepeat", "[", 
       RowBox[{"\"\<.\>\"", ",", "50"}], "]"}], "]"}], ";", 
     RowBox[{
      RowBox[{"MxxDesign", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"Mxx", "[", 
        RowBox[{"x", ",", "z"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Sign", "[", 
         RowBox[{"Mxx", "[", 
          RowBox[{"x", ",", "z"}], "]"}], "]"}], " ", 
        RowBox[{"Abs", "[", 
         RowBox[{"Mxz", "[", 
          RowBox[{"x", ",", "z"}], "]"}], "]"}]}]}]}], ";", 
     RowBox[{
      RowBox[{"MzzDesign", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"Mzz", "[", 
        RowBox[{"x", ",", "z"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Sign", "[", 
         RowBox[{"Mzz", "[", 
          RowBox[{"x", ",", "z"}], "]"}], "]"}], " ", 
        RowBox[{"Abs", "[", 
         RowBox[{"Mxz", "[", 
          RowBox[{"x", ",", "z"}], "]"}], "]"}]}]}]}], ";", 
     RowBox[{
      RowBox[{"MxxPos", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Max", "[", 
       RowBox[{
        RowBox[{"MxxDesign", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", "0"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"MzzPos", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Max", "[", 
       RowBox[{
        RowBox[{"MzzDesign", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", "0"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"MxxNeg", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"MxxDesign", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", "0"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"MzzNeg", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"MzzDesign", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", "0"}], "]"}]}], ";", 
     RowBox[{"waMxxPosPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"MxxPos", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Myy\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", "\"\<Mxx WA +ve XX\>\""}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"waMzzPosPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"MzzPos", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<MMzz WA +ve YY\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"waMxxNegPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"MxxNeg", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<MMxx WA Neg XX\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"waMzzNegPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"MzzNeg", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "z"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Mzz WA Neg YY\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"MzzPosMax", "=", 
      RowBox[{"NMaximize", "[", 
       RowBox[{
        RowBox[{"MzzPos", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "z"}], "}"}], "\[Element]", "domain"}]}], "]"}]}],
      ";", 
     RowBox[{"MxxPosMax", "=", 
      RowBox[{"NMaximize", "[", 
       RowBox[{
        RowBox[{"MxxPos", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "z"}], "}"}], "\[Element]", "domain"}]}], "]"}]}],
      ";", 
     RowBox[{"MzzNegMax", "=", 
      RowBox[{"NMinimize", "[", 
       RowBox[{
        RowBox[{"MzzNeg", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "z"}], "}"}], "\[Element]", "domain"}]}], "]"}]}],
      ";", 
     RowBox[{"MxxNegMax", "=", 
      RowBox[{"NMinimize", "[", 
       RowBox[{
        RowBox[{"MxxNeg", "[", 
         RowBox[{"x", ",", "z"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "z"}], "}"}], "\[Element]", "domain"}]}], "]"}]}],
      ";", 
     RowBox[{"Print", "[", 
      RowBox[{"{", 
       RowBox[{
       "waMxxPosPlot", ",", "waMzzPosPlot", ",", "waMxxNegPlot", ",", 
        "waMzzNegPlot"}], "}"}], "]"}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Maximum +ve Mxx =\>\"", ",", "MxxPosMax", 
       ",", "\"\<  Maximum +ve Mzz =\>\"", ",", "MzzPosMax"}], "]"}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Maximum -ve Mxx =\>\"", ",", "MxxNegMax", 
       ",", "\"\<  Maximum -ve Mzz =\>\"", ",", "MzzNegMax"}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.963398333328508*^9, 3.963398388188768*^9}, 
   3.963398676263178*^9, {3.9633987279851103`*^9, 3.963398728585747*^9}, {
   3.963416040260116*^9, 3.9634161964807377`*^9}, {3.963416249583089*^9, 
   3.9634163100481863`*^9}, {3.963416558061142*^9, 3.96341656255888*^9}, {
   3.963416768477352*^9, 3.9634168188585157`*^9}, {3.96345159096014*^9, 
   3.963451599315502*^9}, 3.963451643341236*^9, {3.963476338270651*^9, 
   3.963476340548356*^9}, {3.963478154936837*^9, 3.963478171644438*^9}, 
   3.9634807426132298`*^9, {3.9634807815325603`*^9, 3.963480931243922*^9}, 
   3.963501518992364*^9, {3.964345849885848*^9, 3.9643458657095413`*^9}, {
   3.964345905273011*^9, 3.9643459434044657`*^9}, {3.964346010541595*^9, 
   3.964346201346401*^9}, {3.964346264664036*^9, 3.964346314562018*^9}, {
   3.965055248360181*^9, 3.965055319052512*^9}, 3.965055368722756*^9, {
   3.965055526285047*^9, 3.965055542256895*^9}, 3.965055675552865*^9, {
   3.965295839516686*^9, 3.965295881985615*^9}, {3.965295948848394*^9, 
   3.9652959803782883`*^9}, {3.965438794112471*^9, 3.965438863729361*^9}, {
   3.9731588604907627`*^9, 3.9731588651074953`*^9}},
 CellLabel->"In[23]:=",
 CellID->1132050647,ExpressionUUID->"7ce042f1-6037-4f88-a70f-c8e8c38c471c"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
XY for displacements in the z direction
wabmXY[mesh_,displacement_,lz_,Y_,h_,\[Nu]_,domain_,contours_,label_,\
plotRange_]\
\>", "Subsubsection",
 CellChangeTimes->{{3.963501550152053*^9, 3.963501558159565*^9}, {
  3.963501798156444*^9, 3.963501808853758*^9}, {3.9654388990950527`*^9, 
  3.9654388996584578`*^9}},ExpressionUUID->"e25a8672-0593-4acc-adb4-\
ae8a8bb6ca91"],

Cell[BoxData[
 RowBox[{
  RowBox[{"wabmXY", "[", 
   RowBox[{
   "mesh_", ",", "displacement_", ",", "lz_", ",", "Y_", ",", "h_", ",", 
    "\[Nu]_", ",", "domain_", ",", "contours_", ",", "label_", ",", 
    "plotRange_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "displacementFunction", ",", "\[Kappa]x", ",", "\[Kappa]y", ",", 
      "\[Kappa]z", ",", "\[Kappa]xy", ",", "\[Kappa]yy", ",", "\[Kappa]yz", ",",
       "\[Kappa]xx", ",", "\[Kappa]zz", ",", "\[Kappa]xz", ",", 
      "flexuralRigidity", ",", "Mxx", ",", "Myy", ",", "Mxy", ",", "bmXXPlot",
       ",", "bmYYPlot", ",", "bmXYPlot", ",", "eom", ",", "MxxDesign", ",", 
      "MyyDesign", ",", "MxxPos", ",", "MyyPos", ",", "MxxNeg", ",", "MyyNeg",
       ",", "waMxxPosPlot", ",", "waMyyPosPlot", ",", "waMxxNegPlot", ",", 
      "waMyyNegPlot", ",", "MxxPosMax", ",", "MyyPosMax", ",", "MxxNegMax", ",",
       "MyyNegMax"}], "}"}], ",", 
    RowBox[{
     RowBox[{"displacementFunction", "=", 
      RowBox[{
       RowBox[{
       "displacement", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}],
        "\[LeftDoubleBracket]", "0", "\[RightDoubleBracket]"}]}], ";", 
     RowBox[{"eom", "=", 
      RowBox[{"EvaluateOnElementMesh", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"{", 
             RowBox[{"x", ",", "2"}], "}"}]], 
           RowBox[{"displacementFunction", "[", 
            RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], ",", 
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"{", 
             RowBox[{"y", ",", "2"}], "}"}]], 
           RowBox[{"displacementFunction", "[", 
            RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], ",", 
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"x", ",", "y"}]], 
           RowBox[{"displacementFunction", "[", 
            RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]}], "}"}], ",", 
        "mesh"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"\[Kappa]xx", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"eom", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
         "[", 
        RowBox[{"x", ",", "y", ",", "lz"}], "]"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"\[Kappa]yy", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"eom", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
         "[", 
        RowBox[{"x", ",", "y", ",", "lz"}], "]"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"\[Kappa]xy", "[", 
       RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"eom", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}],
         "[", 
        RowBox[{"x", ",", "y", ",", "lz"}], "]"}], "]"}]}], ";", 
     RowBox[{"flexuralRigidity", "=", 
      FractionBox[
       RowBox[{"Y", " ", 
        SuperscriptBox["h", "3"]}], 
       RowBox[{"12", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[Nu]", "2"]}], ")"}]}]]}], ";", 
     RowBox[{
      RowBox[{"Mxx", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"-", "flexuralRigidity"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Kappa]xx", "[", 
           RowBox[{"x", ",", "y"}], "]"}], "+", 
          RowBox[{"\[Nu]", " ", 
           RowBox[{"\[Kappa]yy", "[", 
            RowBox[{"x", ",", "y"}], "]"}]}]}], ")"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"Myy", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"-", "flexuralRigidity"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Kappa]yy", "[", 
           RowBox[{"x", ",", "y"}], "]"}], "+", 
          RowBox[{"\[Nu]", " ", 
           RowBox[{"\[Kappa]xx", "[", 
            RowBox[{"x", ",", "y"}], "]"}]}]}], ")"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"Mxy", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"-", "flexuralRigidity"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Nu]"}], ")"}], " ", 
        RowBox[{"\[Kappa]xy", "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "]"}]}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"StringRepeat", "[", 
       RowBox[{"\"\<-\>\"", ",", "50"}], "]"}], "]"}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"Style", "[", 
       RowBox[{"label", ",", "Bold", ",", "Black", ",", "20"}], "]"}], "]"}], 
     ";", 
     RowBox[{"bmXXPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"Mxx", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Mxx\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"bmYYPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"Myy", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Myy\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"bmXYPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"Mxy", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Mxy\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"{", 
       RowBox[{"bmXXPlot", ",", "bmYYPlot", ",", "bmXYPlot"}], "}"}], "]"}], ";", \

     RowBox[{"Print", "[", 
      RowBox[{"StringRepeat", "[", 
       RowBox[{"\"\<.\>\"", ",", "50"}], "]"}], "]"}], ";", 
     RowBox[{
      RowBox[{"MxxDesign", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"Mxx", "[", 
        RowBox[{"x", ",", "y"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Sign", "[", 
         RowBox[{"Mxx", "[", 
          RowBox[{"x", ",", "y"}], "]"}], "]"}], " ", 
        RowBox[{"Abs", "[", 
         RowBox[{"Mxy", "[", 
          RowBox[{"x", ",", "y"}], "]"}], "]"}]}]}]}], ";", 
     RowBox[{
      RowBox[{"MyyDesign", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"Myy", "[", 
        RowBox[{"x", ",", "y"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Sign", "[", 
         RowBox[{"Myy", "[", 
          RowBox[{"x", ",", "y"}], "]"}], "]"}], " ", 
        RowBox[{"Abs", "[", 
         RowBox[{"Mxy", "[", 
          RowBox[{"x", ",", "y"}], "]"}], "]"}]}]}]}], ";", 
     RowBox[{
      RowBox[{"MxxPos", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Max", "[", 
       RowBox[{
        RowBox[{"MxxDesign", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "0"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"MyyPos", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Max", "[", 
       RowBox[{
        RowBox[{"MyyDesign", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "0"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"MxxNeg", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"MxxDesign", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "0"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"MyyNeg", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"MyyDesign", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "0"}], "]"}]}], ";", 
     RowBox[{"waMxxPosPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"MxxPos", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Mxx WA +ve X\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"waMyyPosPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"MyyPos", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Myy WA +ve YY\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"waMxxNegPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"MxxNeg", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Mxx WA Neg XX\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"waMyyNegPlot", "=", 
      RowBox[{"ContourPlot", "[", 
       RowBox[{
        RowBox[{"MyyNeg", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "domain"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"Contours", "\[Rule]", "contours"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Myy WA Neg YY\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
           
           RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
        RowBox[{"ColorFunction", "\[Rule]", 
         RowBox[{"ColorData", "[", "\"\<ThermometerColors\>\"", "]"}]}], ",", 
        
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}]}], "]"}]}], ";", 
     RowBox[{"MxxPosMax", "=", 
      RowBox[{"NMaximize", "[", 
       RowBox[{
        RowBox[{"MxxPos", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "domain"}]}], "]"}]}],
      ";", 
     RowBox[{"MyyPosMax", "=", 
      RowBox[{"NMaximize", "[", 
       RowBox[{
        RowBox[{"MyyPos", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "domain"}]}], "]"}]}],
      ";", 
     RowBox[{"MxxNegMax", "=", 
      RowBox[{"NMinimize", "[", 
       RowBox[{
        RowBox[{"MxxNeg", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "domain"}]}], "]"}]}],
      ";", 
     RowBox[{"MyyNegMax", "=", 
      RowBox[{"NMinimize", "[", 
       RowBox[{
        RowBox[{"MyyNeg", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "domain"}]}], "]"}]}],
      ";", 
     RowBox[{"Print", "[", 
      RowBox[{"{", 
       RowBox[{
       "waMxxPosPlot", ",", "waMyyPosPlot", ",", "waMxxNegPlot", ",", 
        "waMyyNegPlot"}], "}"}], "]"}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Maximum +ve Mxx =\>\"", ",", "MxxPosMax", 
       ",", "\"\<  Maximum +ve Myy =\>\"", ",", "MyyPosMax"}], "]"}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Maximum -ve Mxx =\>\"", ",", "MxxNegMax", 
       ",", "\"\<  Maximum -ve Myy =\>\"", ",", "MyyNegMax"}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.960258653144884*^9, {3.9602586881807537`*^9, 3.960258828531652*^9}, {
   3.9602588667996264`*^9, 3.9602590495477047`*^9}, {3.9602600408718433`*^9, 
   3.960260041076569*^9}, {3.960261676989374*^9, 3.960261684947309*^9}, 
   3.9633303198906393`*^9, {3.9633645490336933`*^9, 3.9633645586248817`*^9}, {
   3.9633953888600397`*^9, 3.963395390539462*^9}, {3.9633954297060623`*^9, 
   3.963395526234655*^9}, {3.963395631939205*^9, 3.963395665616702*^9}, {
   3.963395733043078*^9, 3.9633957863890457`*^9}, {3.963395837113134*^9, 
   3.963395838576139*^9}, {3.9633958703835506`*^9, 3.963395917549573*^9}, {
   3.963395953073629*^9, 3.963396070670641*^9}, {3.963396103251602*^9, 
   3.963396208210346*^9}, 3.963396248032236*^9, {3.963396317516345*^9, 
   3.963396418635236*^9}, {3.963396756936872*^9, 3.963396785119507*^9}, {
   3.9633969597969313`*^9, 3.963396964717311*^9}, {3.9633970052992153`*^9, 
   3.963397006490211*^9}, {3.963397099386569*^9, 3.9633971265568*^9}, 
   3.9633971649082203`*^9, {3.963397217948111*^9, 3.963397306511045*^9}, {
   3.963397943743414*^9, 3.963397973307756*^9}, {3.963398567238709*^9, 
   3.963398594332835*^9}, {3.963398650250114*^9, 3.963398657198154*^9}, 
   3.963398716466291*^9, {3.963398825294292*^9, 3.963398870066305*^9}, {
   3.963398931405244*^9, 3.963399143060556*^9}, {3.963399272323147*^9, 
   3.963399313111525*^9}, {3.963411818866971*^9, 3.9634118749185333`*^9}, {
   3.963415532847453*^9, 3.963415692947029*^9}, {3.9634157325467043`*^9, 
   3.963415739265976*^9}, {3.963415779705153*^9, 3.9634157941372004`*^9}, {
   3.9634159383949842`*^9, 3.963415946593027*^9}, {3.9634781210071163`*^9, 
   3.9634781393737392`*^9}, {3.963480944978779*^9, 3.963481018085869*^9}, {
   3.964346541808909*^9, 3.9643466120512543`*^9}, {3.964346652145549*^9, 
   3.964346716960539*^9}, {3.964348243409924*^9, 3.964348272163252*^9}, {
   3.964348308759068*^9, 3.964348346779351*^9}, {3.964348888356656*^9, 
   3.964348904934094*^9}, {3.964348945786813*^9, 3.9643489614575253`*^9}, {
   3.965055633637455*^9, 3.9650556656366453`*^9}, {3.9652959032063*^9, 
   3.965295937848901*^9}, {3.965296149600425*^9, 3.965296164157632*^9}, 
   3.965296209330923*^9, 3.9654374062150173`*^9, {3.965438241174864*^9, 
   3.965438310243384*^9}},
 CellLabel->"In[24]:=",
 CellID->1265603890,ExpressionUUID->"90f9a4f0-73bf-4520-973e-68bac1ae4c6e"]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bending moment along a line", "Section",
 CellChangeTimes->{{3.964403968079582*^9, 
  3.9644039759971943`*^9}},ExpressionUUID->"4011ba50-2e74-4f6b-a674-\
877fc9ee6bb6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"bendingMoment", "[", 
   RowBox[{
   "displacement_", ",", "coord1_", ",", "coord2_", ",", "z_", ",", "Y_", ",",
     "b_", ",", "d_", ",", "n_", ",", "label_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "EI", ",", "l", ",", "dx", ",", "dy", ",", "dl", ",", "coords", ",", 
      "data", ",", "dispmms", ",", "\[Delta]", ",", "curve", ",", "bm", ",", 
      "v"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"EI", "=", 
        RowBox[{
         FractionBox["1", "12"], " ", "Y", " ", 
         RowBox[{"(", 
          RowBox[{"b", " ", 
           SuperscriptBox["d", "3"]}], ")"}]}]}], ";", 
       RowBox[{"l", "=", 
        RowBox[{"N", "[", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{
              "coord2", "\[LeftDoubleBracket]", "1", 
               "\[RightDoubleBracket]"}], "-", 
              RowBox[{
              "coord1", "\[LeftDoubleBracket]", "1", 
               "\[RightDoubleBracket]"}]}], ")"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{
              "coord2", "\[LeftDoubleBracket]", "2", 
               "\[RightDoubleBracket]"}], "-", 
              RowBox[{
              "coord1", "\[LeftDoubleBracket]", "2", 
               "\[RightDoubleBracket]"}]}], ")"}], "2"]}]], "]"}]}], ";", 
       RowBox[{"dx", "=", 
        RowBox[{"N", "[", 
         FractionBox[
          RowBox[{
           RowBox[{
           "coord2", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "-", 
           RowBox[{
           "coord1", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
           "n"], "]"}]}], ";", 
       RowBox[{"dy", "=", 
        RowBox[{"N", "[", 
         FractionBox[
          RowBox[{
           RowBox[{
           "coord2", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "-", 
           RowBox[{
           "coord1", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}],
           "n"], "]"}]}], ";", 
       RowBox[{"dl", "=", 
        RowBox[{"N", "[", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["dx", "2"], "+", 
           SuperscriptBox["dy", "2"]}]], "]"}]}], ";", 
       RowBox[{"coords", "=", 
        RowBox[{"N", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{
              "coord1", "\[LeftDoubleBracket]", "1", 
               "\[RightDoubleBracket]"}], "+", 
              RowBox[{"i", " ", "dx"}]}], ",", 
             RowBox[{
              RowBox[{
              "coord1", "\[LeftDoubleBracket]", "2", 
               "\[RightDoubleBracket]"}], "+", 
              RowBox[{"i", " ", "dy"}]}], ",", "z"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "n"}], "}"}]}], "]"}], "]"}]}], ";", 
       RowBox[{"data", "=", 
        RowBox[{"N", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"i", " ", "dl"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{
               "displacement", "\[LeftDoubleBracket]", "3", 
                "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "0", 
               "\[RightDoubleBracket]"}], "[", 
              RowBox[{
              "coords", "\[LeftDoubleBracket]", "i", 
               "\[RightDoubleBracket]"}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"Length", "[", "coords", "]"}]}], "}"}]}], "]"}], 
         "]"}]}], ";", 
       RowBox[{"dispmms", "=", 
        RowBox[{"N", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"i", " ", "dl"}], ",", 
             RowBox[{"1000", " ", 
              RowBox[{
               RowBox[{
                RowBox[{
                "displacement", "\[LeftDoubleBracket]", "3", 
                 "\[RightDoubleBracket]"}], "\[LeftDoubleBracket]", "0", 
                "\[RightDoubleBracket]"}], "[", 
               RowBox[{
               "coords", "\[LeftDoubleBracket]", "i", 
                "\[RightDoubleBracket]"}], "]"}]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"Length", "[", "coords", "]"}]}], "}"}]}], "]"}], 
         "]"}]}], ";", 
       RowBox[{"Print", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"label", ",", "Bold", ",", "Black", ",", "20"}], "]"}], 
        "]"}], ";", 
       RowBox[{"ListLinePlot", "[", 
        RowBox[{"dispmms", ",", 
         RowBox[{"PlotLabel", "\[Rule]", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<Deflection mms\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
            RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", "True"}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<Distance m\>\"", ",", "\"\<Deflection mms\>\""}], 
           "}"}]}], ",", 
         RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"\[Delta]", "=", 
        RowBox[{"Interpolation", "[", "data", "]"}]}], ";", 
       RowBox[{
        RowBox[{"curve", "[", "x_", "]"}], "=", 
        RowBox[{
         SuperscriptBox["\[Delta]", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}], ";", 
       RowBox[{
        RowBox[{"bm", "[", "x_", "]"}], ":=", 
        RowBox[{"UnitConvert", "[", 
         RowBox[{
          FractionBox[
           RowBox[{"EI", " ", 
            RowBox[{"curve", "[", "x", "]"}]}], 
           RowBox[{"Quantity", "[", 
            RowBox[{"1", ",", "\"\<Meters\>\""}], "]"}]], ",", 
          RowBox[{"Quantity", "[", 
           RowBox[{"1", ",", "\"\<Kilojoules\>\""}], "]"}]}], "]"}]}], ";", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"bm", "[", "x", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "l"}], "}"}], ",", 
         RowBox[{"PlotLabel", "\[Rule]", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<Bending Moment kJ\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
            RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", "True"}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<Distance m\>\"", ",", "\"\<BM kJ\>\""}], "}"}]}], ",", 
         RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
         RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
         RowBox[{"FillingStyle", "\[Rule]", "LightGreen"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"v", "[", "x_", "]"}], ":=", 
        RowBox[{
         SuperscriptBox["curve", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}], ";", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"UnitConvert", "[", 
          RowBox[{
           FractionBox[
            RowBox[{"EI", " ", 
             RowBox[{"v", "[", "x", "]"}]}], 
            SuperscriptBox[
             RowBox[{"Quantity", "[", 
              RowBox[{"1", ",", "\"\<Meters\>\""}], "]"}], "2"]], ",", 
           RowBox[{"Quantity", "[", 
            RowBox[{"1", ",", "\"\<Kilonewtons\>\""}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "l"}], "}"}], ",", 
         RowBox[{"PlotLabel", "\[Rule]", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<Shear kN\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Pro\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
            RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", "True"}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<Distance m\>\"", ",", "\"\<Shear kN\>\""}], "}"}]}], ",", 
         RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
         RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
         RowBox[{"FillingStyle", "\[Rule]", "LightRed"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellFrame->{{1, 1}, {0, 1}},
 CellChangeTimes->{{3.963710636730918*^9, 3.963710675987974*^9}, {
   3.96371082294375*^9, 3.9637109880371532`*^9}, {3.963711032920587*^9, 
   3.963711062599894*^9}, {3.963711116500989*^9, 3.9637111240010433`*^9}, {
   3.963711163225977*^9, 3.963711230142652*^9}, {3.9637114748359747`*^9, 
   3.9637114974850073`*^9}, {3.96371153298903*^9, 3.9637115411208067`*^9}, {
   3.963711585189783*^9, 3.9637115991754227`*^9}, {3.963711644756032*^9, 
   3.963711708867531*^9}, 3.9637117548553123`*^9, {3.963711833040401*^9, 
   3.963712005998557*^9}, {3.963712038868616*^9, 3.963712172359662*^9}, 
   3.963712257921781*^9, 3.96371230296521*^9, {3.9637123392103148`*^9, 
   3.963712360342451*^9}, {3.9637123994753513`*^9, 3.963712418300733*^9}, {
   3.963712567267061*^9, 3.963712612748047*^9}, 3.963712719218693*^9, {
   3.963712752911602*^9, 3.963712826081068*^9}, {3.9637128798262987`*^9, 
   3.963712884961025*^9}, {3.9637129482459707`*^9, 3.963712949581848*^9}, {
   3.963713010090282*^9, 3.963713042253167*^9}, {3.963713991401918*^9, 
   3.963714002328473*^9}, {3.963714375035446*^9, 3.96371439161165*^9}, 
   3.963714448961548*^9, {3.96371451816567*^9, 3.963714578289163*^9}, {
   3.963714615097981*^9, 3.9637146617792673`*^9}, {3.963714701173378*^9, 
   3.963714789686129*^9}, 3.963714835157526*^9, {3.963715288315243*^9, 
   3.963715319926738*^9}, {3.96371535484344*^9, 3.963715452105692*^9}, {
   3.963715485165024*^9, 3.963715575382092*^9}, 3.963715615338355*^9, {
   3.963715689106284*^9, 3.963715735657484*^9}, {3.963715780718864*^9, 
   3.9637159266661053`*^9}, {3.964403040859152*^9, 3.9644030510314207`*^9}, {
   3.964403236596224*^9, 3.964403250023284*^9}, {3.964403287427702*^9, 
   3.964403336781292*^9}, {3.964403395268463*^9, 3.964403405958437*^9}, {
   3.964403449504974*^9, 3.9644034721255493`*^9}, 3.964403672224647*^9, {
   3.964403886650834*^9, 3.9644038990101137`*^9}, 3.9644273746864367`*^9, 
   3.969328649178301*^9},
 CellLabel->"In[25]:=",
 CellID->1714140851,ExpressionUUID->"072005b1-5989-4659-a0d6-5f475938cabc"]
}, Closed]],

Cell[CellGroupData[{

Cell["Plotting shell contour plots", "Section",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.970483930578929*^9, 
  3.970483946213031*^9}},ExpressionUUID->"b76d2215-9a6c-4fac-8d58-\
8f22b53b9c8c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"overlay", "[", 
   RowBox[{
   "function_", ",", "surface_", ",", "xmin_", ",", "xmax_", ",", "ymin_", ",",
     "ymax_", ",", "nc_", ",", "np_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "texture", ",", "plot2D", ",", "plot3D", ",", "cf", ",", "zmin", ",", 
      "zmax"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"zmin", ",", "zmax"}], "}"}], "=", 
      RowBox[{"MinMax", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"function", "[", 
           RowBox[{"x", ",", "y"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "xmin", ",", "xmax", ",", 
            FractionBox[
             RowBox[{"xmax", "-", "xmin"}], "50"]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", "ymin", ",", "ymax", ",", 
            FractionBox[
             RowBox[{"ymax", "-", "ymin"}], "50"]}], "}"}]}], "]"}], "]"}], 
       "]"}]}], ";", 
     RowBox[{
      RowBox[{"cf", "[", "z_", "]"}], ":=", 
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
       RowBox[{"Rescale", "[", 
        RowBox[{"z", ",", 
         RowBox[{"{", 
          RowBox[{"zmin", ",", "zmax"}], "}"}]}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"plot2D", "=", 
      RowBox[{"Show", "[", 
       RowBox[{"ContourPlot", "[", 
        RowBox[{
         RowBox[{"function", "[", 
          RowBox[{"x", ",", "y"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "xmin", ",", "xmax"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", "ymin", ",", "ymax"}], "}"}], ",", 
         RowBox[{"Contours", "->", "nc"}], ",", 
         RowBox[{"ContourShading", "->", "True"}], ",", 
         RowBox[{"ContourStyle", "->", "Black"}], ",", 
         RowBox[{"ColorFunction", "->", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"cf", "[", "#", "]"}], "&"}], ")"}]}], ",", 
         RowBox[{"ColorFunctionScaling", "->", "False"}], ",", 
         RowBox[{"ContourLabels", "->", "Automatic"}], ",", 
         RowBox[{"PlotLegends", "->", 
          RowBox[{"BarLegend", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"cf", ",", 
              RowBox[{"{", 
               RowBox[{"zmin", ",", "zmax"}], "}"}]}], "}"}], ",", 
            RowBox[{"LegendLabel", "->", "function"}]}], "]"}]}]}], "]"}], 
       "]"}]}], ";", "\n", "\[IndentingNewLine]", 
     RowBox[{"texture", "=", 
      RowBox[{"Rasterize", "[", 
       RowBox[{
        RowBox[{"ContourPlot", "[", 
         RowBox[{
          RowBox[{"function", "[", 
           RowBox[{"x", ",", "y"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "xmin", ",", "xmax"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", "ymin", ",", "ymax"}], "}"}], ",", 
          RowBox[{"Contours", "\[Rule]", "nc"}], ",", 
          RowBox[{"ContourShading", "\[Rule]", "True"}], ",", 
          RowBox[{"ContourStyle", "\[Rule]", "Black"}], ",", 
          RowBox[{"ColorFunction", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"cf", "[", "#1", "]"}], "&"}], ")"}]}], ",", 
          RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
          RowBox[{"Background", "\[Rule]", "None"}], ",", 
          RowBox[{"Frame", "\[Rule]", "False"}], ",", 
          RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
        RowBox[{"Background", "\[Rule]", "None"}]}], "]"}]}], ";", 
     RowBox[{"plot3D", "=", 
      RowBox[{"ParametricPlot3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", 
          RowBox[{"surface", "[", 
           RowBox[{"x", ",", "y"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "xmin", ",", "xmax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", "ymin", ",", "ymax"}], "}"}], ",", 
        RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
        RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
        RowBox[{"PlotPoints", "\[Rule]", "np"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"BoxRatios", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"EdgeForm", "[", "]"}], ",", 
           RowBox[{"FaceForm", "[", 
            RowBox[{"Texture", "[", "texture", "]"}], "]"}]}], "]"}]}], ",", 
        RowBox[{"TextureCoordinateFunction", "\[Rule]", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Rescale", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{"xmin", ",", "xmax"}], "}"}]}], "]"}], ",", 
             RowBox[{"Rescale", "[", 
              RowBox[{"#2", ",", 
               RowBox[{"{", 
                RowBox[{"ymin", ",", "ymax"}], "}"}]}], "]"}]}], "}"}], "&"}],
           ")"}]}], ",", 
        RowBox[{"TextureCoordinateScaling", "\[Rule]", "False"}]}], "]"}]}], ";", 
     RowBox[{"GraphicsColumn", "[", 
      RowBox[{"{", 
       RowBox[{"plot2D", ",", 
        RowBox[{"Legended", "[", 
         RowBox[{"plot3D", ",", 
          RowBox[{"BarLegend", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"cf", ",", 
              RowBox[{"{", 
               RowBox[{"zmin", ",", "zmax"}], "}"}]}], "}"}], ",", 
            RowBox[{"LegendLabel", "\[Rule]", "function"}]}], "]"}]}], 
         "]"}]}], "}"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.970307250373006*^9, 3.970307250376039*^9}, 
   3.9703072975672703`*^9, 3.9703073360445213`*^9, 3.9703075964771*^9, {
   3.97030764705441*^9, 3.970307670940422*^9}, {3.9703077093912773`*^9, 
   3.97030773222729*^9}, {3.970307813540718*^9, 3.970307835847013*^9}, {
   3.970307964355873*^9, 3.9703079676207743`*^9}, 3.970325783080868*^9, {
   3.970325889772496*^9, 3.9703259109587727`*^9}, {3.9703259790752783`*^9, 
   3.970325982365477*^9}, {3.970326019378553*^9, 3.970326030938809*^9}, {
   3.970326077785367*^9, 3.970326106088006*^9}, {3.970326205407652*^9, 
   3.970326243452548*^9}, {3.9703264015289307`*^9, 3.9703264153929253`*^9}, {
   3.970326471864439*^9, 3.970326480519597*^9}, 3.970326540881926*^9, {
   3.970326808441663*^9, 3.970326811887569*^9}, {3.970326844169507*^9, 
   3.970326846777176*^9}},
 CellLabel->"In[26]:=",
 CellID->1809561645,ExpressionUUID->"30506a9a-cc1d-4ce3-8a4c-d982519503e8"]
}, Closed]],

Cell[CellGroupData[{

Cell["Plotting Reactions", "Section",
 CellChangeTimes->{{3.9726456278904953`*^9, 
  3.972645642739122*^9}},ExpressionUUID->"7a1b2f7d-cd66-48fe-9dc0-\
9849a48e7c0d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PlotReactionForces", "[", 
    RowBox[{"mesh_", ",", "reactionForces_", ",", 
     RowBox[{"opts", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "boundaryPoints", ",", "vectors", ",", "magnitudes", ",", 
       "nonZeroIndices", ",", "filteredPoints", ",", "filteredVectors", ",", 
       "filteredMagnitudes", ",", "sampledPoints", ",", "sampledVectors", ",",
        "sampledMagnitudes", ",", "indices", ",", "maxMag", ",", "minMag", ",",
        "meshSize", ",", "scaleFactor", ",", "colorFunc", ",", 
       "coloredArrows", ",", "plot", ",", "legend", ",", "stride", ",", 
       "threshold", ",", "arrowScale", ",", "colorScheme", ",", 
       "arrowheadSize", ",", "showMesh"}], "}"}], ",", 
     RowBox[{"(*", 
      RowBox[{"Get", " ", "options", " ", "with", " ", "defaults"}], "*)"}], 
     RowBox[{
      RowBox[{"stride", "=", 
       RowBox[{"OptionValue", "[", "\"\<Stride\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"threshold", "=", 
       RowBox[{"OptionValue", "[", "\"\<Threshold\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"arrowScale", "=", 
       RowBox[{"OptionValue", "[", "\"\<ArrowScale\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"colorScheme", "=", 
       RowBox[{"OptionValue", "[", "\"\<ColorScheme\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"arrowheadSize", "=", 
       RowBox[{"OptionValue", "[", "\"\<ArrowheadSize\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"showMesh", "=", 
       RowBox[{"OptionValue", "[", "\"\<ShowMesh\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Get", " ", "boundary", " ", "points"}], "*)"}], 
      RowBox[{"boundaryPoints", "=", 
       RowBox[{
        RowBox[{"mesh", "[", "\"\<Coordinates\>\"", "]"}], "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"mesh", "[", "\"\<BoundaryElements\>\"", "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], "//", "Flatten"}], "//", 
          "DeleteDuplicates"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Calculate", " ", "vectors"}], "*)"}], 
      RowBox[{"vectors", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Through", "[", 
          RowBox[{"reactionForces", "[", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"#", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "]"}], "&"}], "/@", 
        "boundaryPoints"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Calculate", " ", "magnitudes"}], "*)"}], 
      RowBox[{"magnitudes", "=", 
       RowBox[{"Norm", "/@", "vectors"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Filter", " ", "out", " ", "zero", " ", "or", " ", "near"}], "-", 
        RowBox[{"zero", " ", "values"}]}], "*)"}], 
      RowBox[{"nonZeroIndices", "=", 
       RowBox[{
        RowBox[{"Position", "[", 
         RowBox[{"magnitudes", ",", 
          RowBox[{"_", "?", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"#", ">", 
              RowBox[{"10", "^", 
               RowBox[{"-", "10"}]}]}], "&"}], ")"}]}]}], "]"}], "//", 
        "Flatten"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "nonZeroIndices", "]"}], "==", "0"}], ",", 
        RowBox[{
         RowBox[{
         "Print", "[", "\"\<Warning: No non-zero reaction forces found!\>\"", 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Return", "[", 
          RowBox[{"mesh", "[", "\"\<Wireframe\>\"", "]"}], "]"}]}]}], "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"filteredPoints", "=", 
       RowBox[{"boundaryPoints", "[", 
        RowBox[{"[", "nonZeroIndices", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"filteredVectors", "=", 
       RowBox[{"vectors", "[", 
        RowBox[{"[", "nonZeroIndices", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"filteredMagnitudes", "=", 
       RowBox[{"magnitudes", "[", 
        RowBox[{"[", "nonZeroIndices", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Get", " ", "magnitude", " ", "range"}], "*)"}], 
      RowBox[{"maxMag", "=", 
       RowBox[{"Max", "[", "filteredMagnitudes", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"minMag", "=", 
       RowBox[{"Min", "[", "filteredMagnitudes", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Apply", " ", "threshold", " ", "filter"}], "*)"}], 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"threshold", ">", "0"}], ",", 
        RowBox[{
         RowBox[{"nonZeroIndices", "=", 
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"filteredMagnitudes", ",", 
             RowBox[{"_", "?", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"#", ">", 
                 RowBox[{"threshold", "*", "maxMag"}]}], "&"}], ")"}]}]}], 
            "]"}], "//", "Flatten"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"filteredPoints", "=", 
          RowBox[{"filteredPoints", "[", 
           RowBox[{"[", "nonZeroIndices", "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"filteredVectors", "=", 
          RowBox[{"filteredVectors", "[", 
           RowBox[{"[", "nonZeroIndices", "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"filteredMagnitudes", "=", 
          RowBox[{"filteredMagnitudes", "[", 
           RowBox[{"[", "nonZeroIndices", "]"}], "]"}]}], ";"}]}], "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Subsample", " ", "by", " ", "stride"}], "*)"}], 
      RowBox[{"indices", "=", 
       RowBox[{"Range", "[", 
        RowBox[{"1", ",", 
         RowBox[{"Length", "[", "filteredPoints", "]"}], ",", "stride"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sampledPoints", "=", 
       RowBox[{"filteredPoints", "[", 
        RowBox[{"[", "indices", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sampledVectors", "=", 
       RowBox[{"filteredVectors", "[", 
        RowBox[{"[", "indices", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sampledMagnitudes", "=", 
       RowBox[{"filteredMagnitudes", "[", 
        RowBox[{"[", "indices", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Print", " ", "info"}], "*)"}], 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Max magnitude: \>\"", ",", "maxMag"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Min magnitude: \>\"", ",", "minMag"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Number of arrows: \>\"", ",", 
        RowBox[{"Length", "[", "sampledPoints", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "Scaling", " ", "factor", " ", "for", " ", "arrow", " ", "length"}], 
       "*)"}], 
      RowBox[{"meshSize", "=", 
       RowBox[{"Mean", "[", 
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"mesh", "[", "\"\<Bounds\>\"", "]"}], "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "2"}], "]"}], "]"}], "-", 
          RowBox[{
           RowBox[{"mesh", "[", "\"\<Bounds\>\"", "]"}], "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"scaleFactor", "=", 
       RowBox[{"arrowScale", "*", 
        RowBox[{"meshSize", "/", "maxMag"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Color", " ", "function"}], "*)"}], 
      RowBox[{"colorFunc", "=", 
       RowBox[{"ColorData", "[", "colorScheme", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Create", " ", "colored", " ", "arrows"}], "*)"}], 
      RowBox[{"coloredArrows", "=", 
       RowBox[{"MapThread", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"colorFunc", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"#3", "-", "minMag"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"maxMag", "-", "minMag"}], ")"}]}], "]"}], ",", 
            "Thick", ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{"#1", ",", 
               RowBox[{"#1", "+", 
                RowBox[{"scaleFactor", "*", "#2"}]}]}], "}"}], "]"}]}], "}"}],
           "&"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "sampledPoints", ",", "sampledVectors", ",", "sampledMagnitudes"}], 
          "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Create", " ", "the", " ", "plot"}], "*)"}], 
      RowBox[{"plot", "=", 
       RowBox[{"Show", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{"showMesh", ",", 
           RowBox[{"mesh", "[", "\"\<Wireframe\>\"", "]"}], ",", 
           RowBox[{"{", "}"}]}], "]"}], ",", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Arrowheads", "[", "arrowheadSize", "]"}], ",", 
            "coloredArrows"}], "}"}], "]"}], ",", 
         RowBox[{"Boxed", "->", "True"}], ",", 
         RowBox[{"Axes", "->", "True"}], ",", 
         RowBox[{"BoxRatios", "->", "Automatic"}], ",", 
         RowBox[{"AxesLabel", "->", 
          RowBox[{"{", 
           RowBox[{"\"\<X\>\"", ",", "\"\<Y\>\"", ",", "\"\<Z\>\""}], "}"}]}],
          ",", 
         RowBox[{"AxesStyle", "->", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", "12"}], "]"}]}], ",", 
         RowBox[{"Lighting", "->", "\"\<Neutral\>\""}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Create", " ", "legend"}], "*)"}], 
      RowBox[{"legend", "=", 
       RowBox[{"BarLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"colorScheme", ",", 
           RowBox[{"{", 
            RowBox[{"minMag", ",", "maxMag"}], "}"}]}], "}"}], ",", 
         RowBox[{"LegendLabel", "->", "\"\<Force Magnitude (N)\>\""}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "Return", " ", "combined", " ", "plot", " ", "with", " ", "legend"}], 
       "*)"}], 
      RowBox[{"Legended", "[", 
       RowBox[{"plot", ",", "legend"}], "]"}]}]}], "]"}]}], "\n"}]], "Input",
 CellChangeTimes->{{3.97264685226121*^9, 3.972646868842606*^9}, {
  3.972646957810986*^9, 3.972646998791407*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"7229f3b6-72df-44c8-91db-1e0fc105f733"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlotReactionForces", "[", 
   RowBox[{"mesh_", ",", "reactionForces_", ",", 
    RowBox[{"opts", ":", 
     RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "nodalCoords", ",", "nodalForces", ",", "magnitudes", ",", "nonZeroIdx", 
      ",", "filteredCoords", ",", "filteredForces", ",", "filteredMagnitudes",
       ",", "sampledCoords", ",", "sampledForces", ",", "sampledMagnitudes", ",",
       "indices", ",", "maxMag", ",", "minMag", ",", "meshSize", ",", 
      "scaleFactor", ",", "colorFunc", ",", "coloredArrows", ",", "plot", ",",
       "legend", ",", "stride", ",", "threshold", ",", "arrowScale", ",", 
      "colorScheme", ",", "arrowheadSize", ",", "showMesh", ",", 
      "forceComponent", ",", "componentLabel", ",", "displayForces"}], "}"}], 
    ",", 
    RowBox[{"(*", 
     RowBox[{"Get", " ", "options", " ", "with", " ", "defaults"}], "*)"}], 
    RowBox[{
     RowBox[{"stride", "=", 
      RowBox[{"OptionValue", "[", "\"\<Stride\>\"", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"threshold", "=", 
      RowBox[{"OptionValue", "[", "\"\<Threshold\>\"", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"arrowScale", "=", 
      RowBox[{"OptionValue", "[", "\"\<ArrowScale\>\"", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"colorScheme", "=", 
      RowBox[{"OptionValue", "[", "\"\<ColorScheme\>\"", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"arrowheadSize", "=", 
      RowBox[{"OptionValue", "[", "\"\<ArrowheadSize\>\"", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"showMesh", "=", 
      RowBox[{"OptionValue", "[", "\"\<ShowMesh\>\"", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"forceComponent", "=", 
      RowBox[{"OptionValue", "[", "\"\<ForceComponent\>\"", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
      "Get", " ", "actual", " ", "nodal", " ", "coordinates", " ", "and", " ",
        "forces", " ", 
       RowBox[{"(", 
        RowBox[{"not", " ", "interpolated"}], ")"}]}], "*)"}], 
     RowBox[{"nodalCoords", "=", 
      RowBox[{"mesh", "[", "\"\<Coordinates\>\"", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"nodalForces", "=", 
      RowBox[{"Transpose", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", "\"\<ValuesOnGrid\>\"", "]"}], "&"}], "/@", 
        "reactionForces"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Calculate", " ", "magnitudes", " ", "for", " ", "filtering"}], 
      "*)"}], 
     RowBox[{"magnitudes", "=", 
      RowBox[{"Norm", "/@", "nodalForces"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"Filter", " ", "out", " ", "zero", " ", "or", " ", "near"}], "-", 
       RowBox[{"zero", " ", "values"}]}], "*)"}], 
     RowBox[{"nonZeroIdx", "=", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"magnitudes", ",", 
         RowBox[{"_", "?", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", ">", 
             RowBox[{"10", "^", 
              RowBox[{"-", "10"}]}]}], "&"}], ")"}]}]}], "]"}], "//", 
       "Flatten"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "nonZeroIdx", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{
        "Print", "[", "\"\<Warning: No non-zero reaction forces found!\>\"", 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"mesh", "[", "\"\<Wireframe\>\"", "]"}], "]"}]}]}], "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"filteredCoords", "=", 
      RowBox[{"nodalCoords", "[", 
       RowBox[{"[", "nonZeroIdx", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"filteredForces", "=", 
      RowBox[{"nodalForces", "[", 
       RowBox[{"[", "nonZeroIdx", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"filteredMagnitudes", "=", 
      RowBox[{"magnitudes", "[", 
       RowBox[{"[", "nonZeroIdx", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"(*", 
      RowBox[{
      "Apply", " ", "component", " ", "filter", " ", "for", " ", "display"}], 
      "*)"}], 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"displayForces", ",", "componentLabel"}], "}"}], "=", 
      RowBox[{"Switch", "[", 
       RowBox[{"forceComponent", ",", "\"\<X\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"filteredForces", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", 
              RowBox[{"{", "1", "}"}]}], "]"}], "]"}], "/.", " ", 
           RowBox[{
            RowBox[{"{", "x_", "}"}], ":>", 
            RowBox[{"{", 
             RowBox[{"x", ",", "0", ",", "0"}], "}"}]}]}], 
          ",", "\"\<Fx (N)\>\""}], "}"}], ",", "\"\<Y\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"filteredForces", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", 
              RowBox[{"{", "2", "}"}]}], "]"}], "]"}], "/.", " ", 
           RowBox[{
            RowBox[{"{", "y_", "}"}], ":>", 
            RowBox[{"{", 
             RowBox[{"0", ",", "y", ",", "0"}], "}"}]}]}], 
          ",", "\"\<Fy (N)\>\""}], "}"}], ",", "\"\<Z\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"filteredForces", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", 
              RowBox[{"{", "3", "}"}]}], "]"}], "]"}], "/.", " ", 
           RowBox[{
            RowBox[{"{", "z_", "}"}], ":>", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "z"}], "}"}]}]}], 
          ",", "\"\<Fz (N)\>\""}], "}"}], ",", "\"\<XY\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"filteredForces", "/.", " ", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x_", ",", "y_", ",", "_"}], "}"}], ":>", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y", ",", "0"}], "}"}]}]}], 
          ",", "\"\<Fxy (N)\>\""}], "}"}], ",", "\"\<XZ\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"filteredForces", "/.", " ", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x_", ",", "_", ",", "z_"}], "}"}], ":>", 
            RowBox[{"{", 
             RowBox[{"x", ",", "0", ",", "z"}], "}"}]}]}], 
          ",", "\"\<Fxz (N)\>\""}], "}"}], ",", "\"\<YZ\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"filteredForces", "/.", " ", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"_", ",", "y_", ",", "z_"}], "}"}], ":>", 
            RowBox[{"{", 
             RowBox[{"0", ",", "y", ",", "z"}], "}"}]}]}], 
          ",", "\"\<Fyz (N)\>\""}], "}"}], ",", "_", ",", 
        RowBox[{"{", 
         RowBox[{"filteredForces", ",", "\"\<Force Magnitude (N)\>\""}], 
         "}"}]}], "  ", 
       RowBox[{"(*", 
        RowBox[{"\"\<All\>\"", " ", "or", " ", "default"}], "*)"}], "]"}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
      "Recalculate", " ", "magnitudes", " ", "for", " ", "display", " ", 
       "forces"}], "*)"}], 
     RowBox[{"filteredMagnitudes", "=", 
      RowBox[{"Norm", "/@", "displayForces"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
      "Remove", " ", "any", " ", "that", " ", "became", " ", "zero", " ", 
       "after", " ", "component", " ", "filtering"}], "*)"}], 
     RowBox[{"nonZeroIdx", "=", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"filteredMagnitudes", ",", 
         RowBox[{"_", "?", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", ">", 
             RowBox[{"10", "^", 
              RowBox[{"-", "10"}]}]}], "&"}], ")"}]}]}], "]"}], "//", 
       "Flatten"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"filteredCoords", "=", 
      RowBox[{"filteredCoords", "[", 
       RowBox[{"[", "nonZeroIdx", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"displayForces", "=", 
      RowBox[{"displayForces", "[", 
       RowBox[{"[", "nonZeroIdx", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"filteredMagnitudes", "=", 
      RowBox[{"filteredMagnitudes", "[", 
       RowBox[{"[", "nonZeroIdx", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "nonZeroIdx", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{
        "Print", 
         "[", "\"\<Warning: No non-zero forces in selected component!\>\"", 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"mesh", "[", "\"\<Wireframe\>\"", "]"}], "]"}]}]}], "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
      "Get", " ", "magnitude", " ", "range", " ", "for", " ", "coloring"}], 
      "*)"}], 
     RowBox[{"maxMag", "=", 
      RowBox[{"Max", "[", "filteredMagnitudes", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"minMag", "=", 
      RowBox[{"Min", "[", "filteredMagnitudes", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Apply", " ", "threshold", " ", "filter"}], "*)"}], 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"threshold", ">", "0"}], ",", 
       RowBox[{
        RowBox[{"nonZeroIdx", "=", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{"filteredMagnitudes", ",", 
            RowBox[{"_", "?", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"#", ">", 
                RowBox[{"threshold", "*", "maxMag"}]}], "&"}], ")"}]}]}], 
           "]"}], "//", "Flatten"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"filteredCoords", "=", 
         RowBox[{"filteredCoords", "[", 
          RowBox[{"[", "nonZeroIdx", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"displayForces", "=", 
         RowBox[{"displayForces", "[", 
          RowBox[{"[", "nonZeroIdx", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"filteredMagnitudes", "=", 
         RowBox[{"filteredMagnitudes", "[", 
          RowBox[{"[", "nonZeroIdx", "]"}], "]"}]}], ";"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Subsample", " ", "by", " ", "stride"}], "*)"}], 
     RowBox[{"indices", "=", 
      RowBox[{"Range", "[", 
       RowBox[{"1", ",", 
        RowBox[{"Length", "[", "filteredCoords", "]"}], ",", "stride"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"sampledCoords", "=", 
      RowBox[{"filteredCoords", "[", 
       RowBox[{"[", "indices", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"sampledForces", "=", 
      RowBox[{"displayForces", "[", 
       RowBox[{"[", "indices", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"sampledMagnitudes", "=", 
      RowBox[{"filteredMagnitudes", "[", 
       RowBox[{"[", "indices", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Print", " ", "info"}], "*)"}], 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Component: \>\"", ",", "forceComponent"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Total force (this component): \>\"", ",", 
       RowBox[{"Total", "[", "displayForces", "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Max nodal force magnitude: \>\"", ",", "maxMag"}], "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Min nodal force magnitude: \>\"", ",", "minMag"}], "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Number of active nodes: \>\"", ",", 
       RowBox[{"Length", "[", "filteredCoords", "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Number of arrows displayed: \>\"", ",", 
       RowBox[{"Length", "[", "sampledCoords", "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
      "Scaling", " ", "factor", " ", "for", " ", "arrow", " ", "length"}], 
      "*)"}], 
     RowBox[{"meshSize", "=", 
      RowBox[{"Mean", "[", 
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"mesh", "[", "\"\<Bounds\>\"", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "2"}], "]"}], "]"}], "-", 
         RowBox[{
          RowBox[{"mesh", "[", "\"\<Bounds\>\"", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"scaleFactor", "=", 
      RowBox[{"arrowScale", "*", 
       RowBox[{"meshSize", "/", "maxMag"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Color", " ", "function"}], "*)"}], 
     RowBox[{"colorFunc", "=", 
      RowBox[{"ColorData", "[", "colorScheme", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Create", " ", "colored", " ", "arrows"}], "*)"}], 
     RowBox[{"coloredArrows", "=", 
      RowBox[{"MapThread", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"colorFunc", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"#3", "-", "minMag"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"maxMag", "-", "minMag", "+", 
               RowBox[{"10", "^", 
                RowBox[{"-", "10"}]}]}], ")"}]}], "]"}], ",", "Thick", ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{"#1", ",", 
              RowBox[{"#1", "+", 
               RowBox[{"scaleFactor", "*", "#2"}]}]}], "}"}], "]"}]}], "}"}], 
         "&"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "sampledCoords", ",", "sampledForces", ",", "sampledMagnitudes"}], 
         "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Create", " ", "the", " ", "plot"}], "*)"}], 
     RowBox[{"plot", "=", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{"showMesh", ",", 
          RowBox[{"mesh", "[", "\"\<Wireframe\>\"", "]"}], ",", 
          RowBox[{"{", "}"}]}], "]"}], ",", 
        RowBox[{"Graphics3D", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Arrowheads", "[", "arrowheadSize", "]"}], ",", 
           "coloredArrows"}], "}"}], "]"}], ",", 
        RowBox[{"Boxed", "->", "True"}], ",", 
        RowBox[{"Axes", "->", "True"}], ",", 
        RowBox[{"AxesLabel", "->", 
         RowBox[{"{", 
          RowBox[{"\"\<X\>\"", ",", "\"\<Y\>\"", ",", "\"\<Z\>\""}], "}"}]}], 
        ",", 
        RowBox[{"AxesStyle", "->", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "12"}], "]"}]}], ",", 
        RowBox[{"Lighting", "->", "\"\<Neutral\>\""}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Create", " ", "legend"}], "*)"}], 
     RowBox[{"legend", "=", 
      RowBox[{"BarLegend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"colorScheme", ",", 
          RowBox[{"{", 
           RowBox[{"minMag", ",", "maxMag"}], "}"}]}], "}"}], ",", 
        RowBox[{"LegendLabel", "->", "componentLabel"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
      "Return", " ", "combined", " ", "plot", " ", "with", " ", "legend"}], 
      "*)"}], 
     RowBox[{"Legended", "[", 
      RowBox[{"plot", ",", "legend"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.972730733863002*^9, 3.972730738725457*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"43082122-638d-4e0e-abc8-4ae7084848b9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "PlotReactionForces", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<Stride\>\"", "->", "5"}], ",", 
     RowBox[{"(*", 
      RowBox[{"Sample", " ", "every", " ", "Nth", " ", "point"}], "*)"}], 
     RowBox[{"\"\<Threshold\>\"", "->", "0"}], ",", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"Filter", " ", "forces"}], "<", 
       RowBox[{"Threshold", "*", "maxMag", " ", 
        RowBox[{"(", 
         RowBox[{"0", "-", "1"}], ")"}]}]}], "*)"}], 
     RowBox[{"\"\<ArrowScale\>\"", "->", "0.15"}], ",", 
     RowBox[{"(*", 
      RowBox[{
      "Arrow", " ", "length", " ", "relative", " ", "to", " ", "mesh", " ", 
       "size"}], "*)"}], 
     RowBox[{"\"\<ColorScheme\>\"", "->", "\"\<TemperatureMap\>\""}], ",", 
     RowBox[{"(*", 
      RowBox[{"Color", " ", "scheme", " ", "name"}], "*)"}], 
     RowBox[{"\"\<ArrowheadSize\>\"", "->", "Medium"}], ",", 
     RowBox[{"(*", 
      RowBox[{"Arrowhead", " ", "size"}], "*)"}], 
     RowBox[{"\"\<ShowMesh\>\"", "->", "True"}], ",", 
     RowBox[{"(*", 
      RowBox[{"Show", " ", "mesh", " ", "wireframe"}], "*)"}], 
     RowBox[{"\"\<ForceComponent\>\"", "->", "\"\<All\>\""}]}], "   ", 
    RowBox[{"(*", 
     RowBox[{"\"\<All\>\"", ",", "\"\<X\>\"", ",", "\"\<Y\>\"", 
      ",", "\"\<Z\>\"", ",", "\"\<XY\>\"", ",", "\"\<XZ\>\"", 
      ",", "\"\<YZ\>\""}], "*)"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.972645764206286*^9, 3.972645831772354*^9}, 
   3.972663112375392*^9},
 CellLabel->"In[29]:=",ExpressionUUID->"9c9a73eb-21f6-4fd9-b902-e8bcb5dbd1b3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Plotting Loads", "Section",
 CellChangeTimes->{{3.9721445189847317`*^9, 
  3.972144523697977*^9}},ExpressionUUID->"72b28ec6-27c6-45d8-b35f-\
a94af010b35b"],

Cell[CellGroupData[{

Cell["Usage", "Subsubsection",
 CellChangeTimes->{{3.972144825562235*^9, 
  3.972144826965192*^9}},ExpressionUUID->"9eb9ff97-7d42-488c-abf8-\
c793d73e07e9"],

Cell[BoxData[
 RowBox[{"meshSurface", ":=", 
  RowBox[{"(*", 
   StyleBox[
    RowBox[{
     RowBox[{"CreateSurfaceFromMesh", "[", 
      RowBox[{"mesh", ",", "4"}], "]"}], ";"}], "Text"], 
   StyleBox[" ", "Text"], "*)"}], " ", 
  StyleBox[
   RowBox[{"(*", 
    StyleBox[
     RowBox[{
     "Mesh", " ", "is", " ", "the", " ", "mesh", " ", "region", " ", "and", " ",
       "the", " ", "number", " ", "is", " ", "the", " ", "number", " ", "of", 
      " ", "the", " ", "ElementMarker"}], "Text",
     FontWeight->"Plain",
     FontColor->RGBColor[
      0.26999313344014647`, 0.824277103837644, 0.8648050659952697]], "*)"}], 
   "Text",
   FontWeight->"Bold"], "\n", 
  RowBox[{
   RowBox[{"pressureFunc", "[", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], "]"}], ":=", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "40000"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"z", "/", "4"}]}], ")"}]}], ";"}], "*)"}], 
   StyleBox[" ", "Text"], 
   RowBox[{"(*", 
    StyleBox[
     RowBox[{
     "Whatever", " ", "the", " ", "pressure", " ", "function", " ", "used", " ", 
      RowBox[{"is", "."}]}], "Text"], "*)"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"VisualizeSurfacePressure", "[", 
    RowBox[{"meshSurface", ",", "pressureFunc", ",", 
     RowBox[{"\"\<ArrowScale\>\"", "->", "0.8"}], ",", 
     RowBox[{"(*", 
      RowBox[{"Adjust", " ", "for", " ", "visual", " ", "clarity"}], "*)"}], 
     RowBox[{"\"\<ColorScheme\>\"", "->", "\"\<TemperatureMap\>\""}], ",", 
     RowBox[{"\"\<ShowSurface\>\"", "->", "True"}], ",", 
     RowBox[{"\"\<ShowLegend\>\"", "->", "True"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.972144833687138*^9, 3.9721448336888027`*^9}, 
   3.9721448853336897`*^9, {3.97214492904459*^9, 3.972145036886677*^9}, 
   3.972145230893093*^9},
 CellLabel->"In[30]:=",ExpressionUUID->"27ba352b-593c-4ba1-a036-628ed8cc2e6f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Visualise surface pressure", "Subsubsection",
 CellChangeTimes->{{3.972144647461651*^9, 
  3.9721446607558727`*^9}},ExpressionUUID->"1887ea8d-28d7-4fdc-b70c-\
3c72dbf89793"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "General", " ", "function", " ", "to", " ", "visualize", " ", "normal", " ",
     "pressure", " ", "on", " ", "any", " ", "surface"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VisualizeSurfacePressure", "[", 
      RowBox[{"surface_", ",", "pressureFunc_", ",", 
       RowBox[{"opts", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "points", ",", "normals", ",", "pressures", ",", "arrows", ",", 
         "surfaceGraphic", ",", "nPoints", ",", "arrowScale", ",", 
         "colorScheme", ",", "showSurface", ",", "showLegend", ",", "pMin", ",",
          "pMax", ",", "maxAbsP", ",", "mainPlot", ",", "legend", ",", 
         "legendSteps", ",", "scaleText"}], "}"}], ",", 
       RowBox[{"(*", 
        RowBox[{"Extract", " ", "options", " ", "with", " ", "defaults"}], 
        "*)"}], 
       RowBox[{
        RowBox[{"nPoints", "=", 
         RowBox[{"OptionValue", "[", "\"\<SamplePoints\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"arrowScale", "=", 
         RowBox[{"OptionValue", "[", "\"\<ArrowScale\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"colorScheme", "=", 
         RowBox[{"OptionValue", "[", "\"\<ColorScheme\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"showSurface", "=", 
         RowBox[{"OptionValue", "[", "\"\<ShowSurface\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"showLegend", "=", 
         RowBox[{"OptionValue", "[", "\"\<ShowLegend\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "Generate", " ", "sample", " ", "points", " ", "on", " ", "the", " ",
           "surface"}], "*)"}], 
        RowBox[{"points", "=", 
         RowBox[{"surface", "[", "\"\<Points\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "Calculate", " ", "normals", " ", "at", " ", "each", " ", "point"}], 
         "*)"}], 
        RowBox[{"normals", "=", 
         RowBox[{"surface", "[", "\"\<Normals\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "Calculate", " ", "pressure", " ", "at", " ", "each", " ", "point"}],
          "*)"}], 
        RowBox[{"pressures", "=", 
         RowBox[{"pressureFunc", "/@", "points"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "Normalize", " ", "pressures", " ", "for", " ", "color", " ", 
          "mapping"}], "*)"}], 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"pMin", ",", "pMax"}], "}"}], "=", 
         RowBox[{"MinMax", "[", "pressures", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"pRange", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"pMax", "==", "pMin"}], ",", "1", ",", 
           RowBox[{"pMax", "-", "pMin"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"maxAbsP", "=", 
         RowBox[{"Max", "[", 
          RowBox[{
           RowBox[{"Abs", "[", "pMin", "]"}], ",", 
           RowBox[{"Abs", "[", "pMax", "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"maxAbsP", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"maxAbsP", "==", "0"}], ",", "1", ",", "maxAbsP"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"Create", " ", "arrows", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"negative", " ", "pressure"}], "=", 
             RowBox[{"inward", " ", "normal"}]}], ",", 
            RowBox[{"positive", "=", "outward"}]}], ")"}]}], "*)"}], 
        RowBox[{"(*", 
         RowBox[{
         "Arrow", " ", "length", " ", "is", " ", "proportional", " ", "to", " ",
           "pressure", " ", "magnitude"}], "*)"}], 
        RowBox[{"arrows", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"With", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"pt", "=", 
                RowBox[{"points", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], ",", 
               RowBox[{"normal", "=", 
                RowBox[{"normals", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], ",", 
               RowBox[{"p", "=", 
                RowBox[{"pressures", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}]}], "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"maxAbsP", "!=", "0"}], "&&", 
                RowBox[{
                 RowBox[{"Norm", "[", "normal", "]"}], ">", "0"}]}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "colorScheme", "]"}], "[", 
                  RowBox[{"Rescale", "[", 
                   RowBox[{"p", ",", 
                    RowBox[{"{", 
                    RowBox[{"pMin", ",", "pMax"}], "}"}]}], "]"}], "]"}], ",", 
                 RowBox[{"Thickness", "[", "0.005", "]"}], ",", 
                 RowBox[{"Arrow", "[", 
                  RowBox[{"{", 
                   RowBox[{"pt", ",", 
                    RowBox[{"pt", "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"p", "/", "maxAbsP"}], ")"}], "*", "arrowScale", "*",
                     "normal"}]}]}], "}"}], "]"}]}], "}"}], ",", "Nothing"}], 
              "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"Length", "[", "points", "]"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"Create", " ", "surface", " ", "graphic"}], "*)"}], 
        RowBox[{"surfaceGraphic", "=", 
         RowBox[{"If", "[", 
          RowBox[{"showSurface", ",", 
           RowBox[{"surface", "[", "\"\<Graphic\>\"", "]"}], ",", 
           RowBox[{"{", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"Create", " ", "main", " ", "plot"}], "*)"}], 
        RowBox[{"mainPlot", "=", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"surfaceGraphic", ",", "arrows"}], "}"}], ",", 
           RowBox[{"Axes", "->", "True"}], ",", 
           RowBox[{"AxesLabel", "->", 
            RowBox[{"{", 
             RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], 
             "}"}]}], ",", 
           RowBox[{"BoxRatios", "->", "Automatic"}], ",", 
           RowBox[{"Lighting", "->", "\"\<Neutral\>\""}], ",", 
           RowBox[{"ImageSize", "->", "Large"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"Create", " ", "legend", " ", "if", " ", "requested"}], 
         "*)"}], 
        RowBox[{"If", "[", 
         RowBox[{"showLegend", ",", 
          RowBox[{"(*", 
           RowBox[{"Pre", "-", 
            RowBox[{
            "compute", " ", "scale", " ", "text", " ", "to", " ", "avoid", " ",
              "evaluation", " ", "issues"}]}], "*)"}], 
          RowBox[{
           RowBox[{"scaleText", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"maxAbsP", ">", "0"}], ",", 
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{"\"\<\[Rule] \>\"", ",", 
                 RowBox[{"ToString", "[", 
                  RowBox[{"Round", "[", 
                   RowBox[{
                    RowBox[{"maxAbsP", "/", "1000"}], ",", "0.1"}], "]"}], 
                  "]"}], ",", "\"\< kPa = \>\"", ",", 
                 RowBox[{"ToString", "[", 
                  RowBox[{"Round", "[", 
                   RowBox[{"arrowScale", ",", "0.01"}], "]"}], "]"}], 
                 ",", "\"\< units\>\""}], "}"}], "]"}], 
              ",", "\"\<No pressure applied\>\""}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"legend", "=", 
            RowBox[{"BarLegend", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"colorScheme", ",", 
                RowBox[{"{", 
                 RowBox[{"pMin", ",", "pMax"}], "}"}]}], "}"}], ",", 
              RowBox[{"LegendLabel", "->", "\"\<Pressure (Pa)\>\""}], ",", 
              RowBox[{"LegendMarkerSize", "->", "300"}], ",", 
              RowBox[{"LabelStyle", "->", 
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{"FontSize", "->", "12"}], ",", "Black"}], "]"}]}]}], 
             "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{"Add", " ", "arrow", " ", "scale", " ", "reference"}], 
            "*)"}], 
           RowBox[{"Legended", "[", 
            RowBox[{"mainPlot", ",", 
             RowBox[{"Column", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"legend", ",", 
                 RowBox[{"Spacer", "[", "10", "]"}], ",", 
                 RowBox[{"Grid", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Style", "[", 
                    
                    RowBox[{"\"\<Arrow Length Scale:\>\"", ",", "Bold", ",", 
                    "12"}], "]"}], "}"}], ",", 
                    RowBox[{"{", "scaleText", "}"}]}], "}"}], ",", 
                   RowBox[{"Alignment", "->", "Left"}]}], "]"}]}], "}"}], ",", 
               RowBox[{"Alignment", "->", "Center"}]}], "]"}]}], "]"}]}], ",",
           "mainPlot"}], "]"}]}]}], "]"}]}], ";"}], "\n"}]}]], "Input",
 CellChangeTimes->{3.972183385310155*^9, 3.972183711129499*^9, 
  3.972183798327806*^9},
 CellLabel->"In[31]:=",ExpressionUUID->"79ec5f21-a164-4719-96f1-8ccc5e474759"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "VisualizeSurfacePressure", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<SamplePoints\>\"", "->", "100"}], ",", 
     RowBox[{"\"\<ArrowScale\>\"", "->", "0.5"}], ",", 
     RowBox[{"\"\<ColorScheme\>\"", "->", "\"\<TemperatureMap\>\""}], ",", 
     RowBox[{"\"\<ShowSurface\>\"", "->", "True"}], ",", 
     RowBox[{"\"\<ShowLegend\>\"", "->", "True"}]}], "}"}]}], ";"}]], "Input",\

 CellLabel->"In[32]:=",ExpressionUUID->"a031a051-4322-4eec-9ba1-589d03a00995"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Create surface from mesh by element marker", "Section",
 CellChangeTimes->{{3.972144561550949*^9, 
  3.972144577085958*^9}},ExpressionUUID->"013ca7d9-34ab-46de-88d1-\
1bd9c60e81af"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Extract", " ", "surface", " ", "from", " ", "mesh", " ", "by", " ", 
    "element", " ", "marker"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CreateSurfaceFromMesh", "[", 
      RowBox[{"mesh_", ",", "marker_", ",", 
       RowBox[{"opts", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "boundaryElements", ",", "markerElements", ",", "coords", ",", 
         "elements", ",", "faces", ",", "points", ",", "normals", ",", 
         "surfGraphic", ",", "centroids", ",", "faceNormals"}], "}"}], ",", 
       RowBox[{"(*", 
        RowBox[{"Get", " ", "mesh", " ", "coordinates"}], "*)"}], 
       RowBox[{
        RowBox[{"coords", "=", 
         RowBox[{"mesh", "[", "\"\<Coordinates\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"Get", " ", "boundary", " ", "elements"}], "*)"}], 
        RowBox[{"boundaryElements", "=", 
         RowBox[{"mesh", "[", "\"\<BoundaryElements\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "Extract", " ", "elements", " ", "with", " ", "specified", " ", 
          "marker"}], "*)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "boundaryElements", "]"}], ">", "0"}], ",", 
          
          RowBox[{
           RowBox[{"elements", "=", 
            RowBox[{"boundaryElements", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"markers", "=", 
            RowBox[{"boundaryElements", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"markerElements", "=", 
            RowBox[{"Pick", "[", 
             RowBox[{"elements", ",", "markers", ",", "marker"}], "]"}]}], 
           ";"}], ",", 
          RowBox[{
           RowBox[{
           "Print", "[", "\"\<No boundary elements found in mesh\>\"", "]"}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "markerElements", "]"}], "==", "0"}], ",", 
          RowBox[{
           RowBox[{"Print", "[", 
            RowBox[{"\"\<No elements found with marker \>\"", ",", "marker"}],
             "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "Get", " ", "face", " ", "points", " ", "and", " ", "calculate", " ",
           "centroids"}], "*)"}], 
        RowBox[{"faces", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"coords", "[", 
            RowBox[{"[", "#", "]"}], "]"}], "&"}], "/@", "markerElements"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"centroids", "=", 
         RowBox[{"Mean", "/@", "faces"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "Calculate", " ", "face", " ", "normals", " ", "using", " ", "cross",
           " ", "product"}], "*)"}], 
        RowBox[{"faceNormals", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"With", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"face", "=", 
               RowBox[{"faces", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Length", "[", "face", "]"}], ">=", "3"}], ",", 
               RowBox[{"(*", 
                RowBox[{
                "For", " ", "triangular", " ", "or", " ", "quad", " ", 
                 "faces"}], "*)"}], 
               RowBox[{"Normalize", "[", 
                RowBox[{"Cross", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"face", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "-", 
                   RowBox[{"face", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                  RowBox[{
                   RowBox[{"face", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "-", 
                   RowBox[{"face", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], " ", 
              RowBox[{"(*", 
               RowBox[{
               "default", " ", "if", " ", "face", " ", "has", " ", "fewer", " ",
                 "than", " ", "3", " ", "points"}], "*)"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"Length", "[", "faces", "]"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"Create", " ", "surface", " ", "graphic"}], "*)"}], 
        RowBox[{"surfGraphic", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Opacity", "[", "0.3", "]"}], ",", "Cyan", ",", 
           RowBox[{"GraphicsComplex", "[", 
            RowBox[{"coords", ",", 
             RowBox[{"Polygon", "[", "markerElements", "]"}]}], "]"}]}], 
          "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"<|", 
         RowBox[{
          RowBox[{"\"\<Points\>\"", "->", "centroids"}], ",", 
          RowBox[{"\"\<Normals\>\"", "->", "faceNormals"}], ",", 
          RowBox[{"\"\<Graphic\>\"", "->", "surfGraphic"}], ",", 
          RowBox[{"\"\<Faces\>\"", "->", "faces"}], ",", 
          RowBox[{"\"\<Elements\>\"", "->", "markerElements"}]}], "|>"}]}]}], 
      "]"}]}], ";"}], "\n"}]}]], "Input",
 CellChangeTimes->{3.972183482439145*^9},
 CellLabel->"In[33]:=",ExpressionUUID->"6eb830da-0fa7-4c31-962f-7c77847b1a78"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Combine", " ", "multiple", " ", "surfaces", " ", "from", " ", "different",
     " ", "element", " ", "markers"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CombineSurfaces", "[", "surfaces_List", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"allPoints", ",", "allNormals", ",", "allGraphics"}], "}"}], ",", 
       RowBox[{
        RowBox[{"allPoints", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", "\"\<Points\>\"", "]"}], "&"}], "/@", 
            "surfaces"}], ",", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"allNormals", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", "\"\<Normals\>\"", "]"}], "&"}], "/@", 
            "surfaces"}], ",", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"allGraphics", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", "\"\<Graphic\>\"", "]"}], "&"}], "/@", 
            "surfaces"}], ",", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"<|", 
         RowBox[{
          RowBox[{"\"\<Points\>\"", "->", "allPoints"}], ",", 
          RowBox[{"\"\<Normals\>\"", "->", "allNormals"}], ",", 
          RowBox[{"\"\<Graphic\>\"", "->", "allGraphics"}]}], "|>"}]}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Extract", " ", "and", " ", "combine", " ", "surfaces", " ", "from", " ", 
     "multiple", " ", "element", " ", "markers"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CreateCombinedSurfaceFromMesh", "[", 
      RowBox[{"mesh_", ",", "markers_List", ",", 
       RowBox[{"opts", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "surfaces", "}"}], ",", 
       RowBox[{
        RowBox[{"surfaces", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"CreateSurfaceFromMesh", "[", 
            RowBox[{"mesh", ",", "marker"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"marker", ",", "markers"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"Remove", " ", "any", " ", "failed", " ", "surfaces"}], 
         "*)"}], 
        RowBox[{"surfaces", "=", 
         RowBox[{"DeleteCases", "[", 
          RowBox[{"surfaces", ",", "$Failed"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "surfaces", "]"}], "==", "0"}], ",", 
          RowBox[{
           RowBox[{"Print", "[", "\"\<No valid surfaces found\>\"", "]"}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"CombineSurfaces", "[", "surfaces", "]"}]}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.972182989869338*^9, 3.972183020387895*^9}, {
  3.972183493659069*^9, 3.972183516477219*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"0ac1569b-fa44-46d0-a4b8-6f5baf317531"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Options", "[", "CreateCombinedSurfaceFromMesh", "]"}], "=", 
  RowBox[{"{", "}"}]}]], "Input",
 CellLabel->"In[36]:=",ExpressionUUID->"af23cb1f-d424-4866-ace4-e420b68e676e"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.972183108448196*^9, 3.972183529244289*^9, {3.972184770018746*^9, 
   3.9721847861013117`*^9}, 3.972208967112802*^9, {3.972211017149342*^9, 
   3.972211045888092*^9}, 3.973183436430867*^9},
 CellLabel->
  "Out[165]=",ExpressionUUID->"a15b007c-f9c2-45fb-9556-812ad6639da0"]
}, Open  ]]
}, Closed]]
},
WindowToolbars->{"RulerBar", "MultipurposeBar"},
WindowSize->{967, 826},
WindowMargins->{{359, Automatic}, {Automatic, 0}},
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "MyBookStyles.nb"]]}, 
  WindowSize -> {808, 911}, 
  WindowMargins -> {{228, Automatic}, {Automatic, 124}}, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 8, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
ExpressionUUID->"4337c42e-1f8b-4a5b-a75b-af8138f8b7d7"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "markers"->{
  Cell[5915, 161, 248, 3, 46, "Section",ExpressionUUID->"334acca0-80cd-49bf-b4f7-6ea9e2a7a4e1",
   CellTags->"markers"]},
 "ChatGeneratedCell"->{
  Cell[19299, 495, 1415, 28, 226, "Input",ExpressionUUID->"58ff7823-8985-458c-ba60-9e6d1554d2bc",
   CellTags->"ChatGeneratedCell",
   CellID->1788502562]},
 "stressStrain"->{
  Cell[28769, 739, 326, 6, 24, "Subsubsection",ExpressionUUID->"b8132765-f72f-4979-a3c3-4df5e730790f",
   CellTags->"stressStrain"]},
 "Deformation"->{
  Cell[36139, 914, 192, 3, 52, "Subsubsection",ExpressionUUID->"e58d3a59-ace2-41f2-8e6d-dd3a172cc15c",
   CellTags->"Deformation"]},
 "BendingMoment"->{
  Cell[38517, 969, 240, 4, 27, "Subsection",ExpressionUUID->"39aa569a-117c-49e0-9253-d997040faa72",
   CellTags->"BendingMoment"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"markers", 190868, 4668},
 {"ChatGeneratedCell", 191014, 4671},
 {"stressStrain", 191190, 4675},
 {"Deformation", 191342, 4678},
 {"BendingMoment", 191495, 4681}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 222, 4, 118, "Section",ExpressionUUID->"b5dfebf7-454d-40a9-a414-29cced35b26b"],
Cell[801, 28, 350, 6, 43, "Input",ExpressionUUID->"a79ad557-ee53-47cb-9718-f3bfd95d138b",
 CellID->2133587866]
}, Open  ]],
Cell[CellGroupData[{
Cell[1188, 39, 154, 3, 106, "Section",ExpressionUUID->"c19addc3-2699-4eb8-87ac-e683ac7ec89e"],
Cell[1345, 44, 870, 14, 46, "Text",ExpressionUUID->"fefd848b-2548-43e0-82ca-f9c128a9ba5e"],
Cell[2218, 60, 2171, 50, 189, "Input",ExpressionUUID->"ad73b77e-42f6-4afc-88da-0ef1248dff08",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[4426, 115, 249, 5, 52, "Section",ExpressionUUID->"de2baf15-d953-4474-b5bc-7e6740b1ab52"],
Cell[4678, 122, 293, 6, 20, "Text",ExpressionUUID->"15bbaf68-e48f-4efa-b171-6515a0f0c43a"],
Cell[4974, 130, 301, 7, 40, "Input",ExpressionUUID->"08d3a7a2-da8d-44d3-8bd4-6034fea6a39a",
 InitializationCell->True],
Cell[5278, 139, 145, 3, 20, "Text",ExpressionUUID->"c3e21b23-a67d-46ec-94e2-86bd516902ff"],
Cell[CellGroupData[{
Cell[5448, 146, 233, 4, 20, "Input",ExpressionUUID->"9c9afd85-1aaf-45f7-b8dd-9ecc31405a2a"],
Cell[5684, 152, 182, 3, 20, "Output",ExpressionUUID->"5a1a4094-8113-45fa-bee7-486198fc3fc6"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[5915, 161, 248, 3, 46, "Section",ExpressionUUID->"334acca0-80cd-49bf-b4f7-6ea9e2a7a4e1",
 CellTags->"markers"],
Cell[6166, 166, 296, 7, 60, "Text",ExpressionUUID->"9460819b-a602-4f2a-afd8-848b185a3216"],
Cell[6465, 175, 5088, 107, 475, "Input",ExpressionUUID->"f6be4547-729c-48f1-9f89-9542ea22e5b3",
 CellID->234031570],
Cell[11556, 284, 296, 4, 36, "Text",ExpressionUUID->"93e71644-cb37-4b96-a486-40b65e7aabeb"],
Cell[CellGroupData[{
Cell[11877, 292, 247, 3, 52, "Subsubsection",ExpressionUUID->"79ee2312-db14-4aa2-b0b9-67f804e01088",
 CellID->1567672406],
Cell[12127, 297, 980, 24, 100, "Input",ExpressionUUID->"20f96f47-2f82-48cb-b21c-5bbd749035a0",
 CellID->1183479497]
}, Open  ]],
Cell[CellGroupData[{
Cell[13144, 326, 298, 4, 52, "Subsubsection",ExpressionUUID->"9e4123e2-e226-4ab1-bd9c-9f0e798fffef",
 CellID->1962190520],
Cell[13445, 332, 303, 4, 36, "Text",ExpressionUUID->"1ad80b18-abec-4275-aee1-589e65d7517f",
 CellID->1033104820]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13797, 342, 403, 7, 111, "Section",ExpressionUUID->"35d7e829-f2ab-487d-b05c-7ca72f76ead5"],
Cell[CellGroupData[{
Cell[14225, 353, 183, 2, 53, "Subsection",ExpressionUUID->"969cc214-14dd-4791-bf85-f051962f165d",
 CellID->52884170],
Cell[CellGroupData[{
Cell[14433, 359, 220, 2, 43, "Subsubsection",ExpressionUUID->"56705a52-d115-4c28-9d19-15f4c9df5997",
 CellID->1913498979],
Cell[CellGroupData[{
Cell[14678, 365, 1853, 49, 172, "Input",ExpressionUUID->"e6e47453-b1f0-47e9-9631-9ca043fc9f3f",
 CellID->1609726228],
Cell[16534, 416, 2310, 63, 70, "Output",ExpressionUUID->"29b9a6eb-9089-4fba-8a3e-1d12ab9ad368"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18893, 485, 224, 2, 35, "Subsubsection",ExpressionUUID->"9acb4e8d-c1c5-4d2d-9d98-d1cc79d55632",
 CellID->1175021703],
Cell[19120, 489, 176, 4, 29, "Input",ExpressionUUID->"6f70e6db-7fca-4a77-8df5-57c6fea81ae4",
 CellID->330144509],
Cell[19299, 495, 1415, 28, 226, "Input",ExpressionUUID->"58ff7823-8985-458c-ba60-9e6d1554d2bc",
 CellTags->"ChatGeneratedCell",
 CellID->1788502562]
}, Closed]],
Cell[CellGroupData[{
Cell[20751, 528, 263, 5, 35, "Subsubsection",ExpressionUUID->"6a4a0eec-3603-415a-9c33-36008358e62a",
 CellID->1033952475],
Cell[21017, 535, 1448, 33, 111, "Input",ExpressionUUID->"55efd9fa-d007-4c01-bd49-130d1dae12c1",
 CellID->201575801]
}, Open  ]],
Cell[CellGroupData[{
Cell[22502, 573, 313, 6, 43, "Subsubsection",ExpressionUUID->"77137630-3612-46fd-9ee0-0c96f79301fb",
 CellID->1302776088],
Cell[22818, 581, 965, 26, 70, "Input",ExpressionUUID->"a39b8c53-2274-433a-b48f-46c144fa8757",
 CellID->14446204]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23844, 614, 171, 3, 46, "Section",ExpressionUUID->"212bd13d-8610-48ad-9a19-cc9344fcea7e"],
Cell[CellGroupData[{
Cell[24040, 621, 186, 2, 52, "Subsubsection",ExpressionUUID->"8820580f-da57-4472-8aee-c11f91d4f726"],
Cell[24229, 625, 1441, 29, 100, "Input",ExpressionUUID->"e167e86b-24ce-4165-829e-76789ccf40c9",
 CellID->1804367117]
}, Open  ]],
Cell[CellGroupData[{
Cell[25707, 659, 264, 4, 60, "Subsubsection",ExpressionUUID->"aff45c37-3b2d-4b37-901f-37db56a2e254",
 CellID->380012319],
Cell[CellGroupData[{
Cell[25996, 667, 458, 9, 33, "Input",ExpressionUUID->"ec975025-6c1a-43b7-8f1a-9f4d45901c23",
 CellID->1911097996],
Cell[26457, 678, 484, 9, 36, "Output",ExpressionUUID->"842aff80-eeef-4121-a371-6c68b96b1b29"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27002, 694, 171, 3, 106, "Section",ExpressionUUID->"196cfdd4-feb1-4170-b349-33e7071ee877"],
Cell[CellGroupData[{
Cell[27198, 701, 200, 2, 60, "Subsubsection",ExpressionUUID->"87cc6f76-b076-4dee-9485-3027acaae303",
 CellID->210438518],
Cell[27401, 705, 1331, 29, 131, "Input",ExpressionUUID->"cf007ac4-0af7-420d-ba2f-fc43b7ef1cf7",
 CellID->85944229]
}, Closed]],
Cell[CellGroupData[{
Cell[28769, 739, 326, 6, 24, "Subsubsection",ExpressionUUID->"b8132765-f72f-4979-a3c3-4df5e730790f",
 CellTags->"stressStrain"],
Cell[29098, 747, 1022, 22, 100, "Input",ExpressionUUID->"42157021-6669-4361-87f8-643a438aeb1c",
 CellID->1276017516],
Cell[30123, 771, 5979, 138, 587, "Input",ExpressionUUID->"1ad3d87c-6d10-49a3-9fff-e98345f3d70e",
 CellID->808510932]
}, Open  ]],
Cell[CellGroupData[{
Cell[36139, 914, 192, 3, 52, "Subsubsection",ExpressionUUID->"e58d3a59-ace2-41f2-8e6d-dd3a172cc15c",
 CellTags->"Deformation"],
Cell[36334, 919, 2146, 45, 131, "Input",ExpressionUUID->"55fda59b-6656-4b67-8865-5f5163f0c2e9",
 CellID->582074681]
}, Closed]],
Cell[CellGroupData[{
Cell[38517, 969, 240, 4, 27, "Subsection",ExpressionUUID->"39aa569a-117c-49e0-9253-d997040faa72",
 CellTags->"BendingMoment"],
Cell[CellGroupData[{
Cell[38782, 977, 386, 6, 52, "Subsubsection",ExpressionUUID->"e256d30f-9e6a-46a3-943b-9a07367c593b"],
Cell[39171, 985, 256, 5, 36, "CodeText",ExpressionUUID->"14e2872e-0778-45be-bb87-a10e4f6f116f",
 CellID->874332644],
Cell[39430, 992, 8916, 209, 624, "Input",ExpressionUUID->"178de30f-f590-4efb-82f6-37bf7b5b981b",
 CellID->1611045504]
}, Closed]],
Cell[CellGroupData[{
Cell[48383, 1206, 238, 4, 24, "Subsubsection",ExpressionUUID->"6cee7dbf-dcd4-4b7c-b91e-bfc69c33a91d"],
Cell[48624, 1212, 7861, 192, 603, "Input",ExpressionUUID->"255bcb21-247c-4220-8995-c31751c9e565",
 CellID->1249065613]
}, Closed]],
Cell[CellGroupData[{
Cell[56522, 1409, 237, 4, 24, "Subsubsection",ExpressionUUID->"a5d72e17-77a5-4afe-8f36-bf24b7d2e33a"],
Cell[56762, 1415, 8457, 203, 624, "Input",ExpressionUUID->"7f3fbcf6-85f9-4992-b74e-2b859b6f0d4a",
 CellID->2117903545]
}, Closed]],
Cell[65234, 1621, 243, 4, 24, "Subsubsection",ExpressionUUID->"c6ab4482-c835-4bc5-918a-176c4299aca0"],
Cell[CellGroupData[{
Cell[65502, 1629, 428, 9, 44, "Subsubsection",ExpressionUUID->"22c15839-5c7d-402d-91af-8b5eae579ef8"],
Cell[65933, 1640, 18419, 421, 1290, "Input",ExpressionUUID->"e8f3eb27-5974-4148-a6bf-f000e209abe2",
 CellID->1879943605]
}, Closed]],
Cell[CellGroupData[{
Cell[84389, 2066, 375, 8, 44, "Subsubsection",ExpressionUUID->"d5cbf7d5-f80d-4562-a9d8-a0c602033a32"],
Cell[84767, 2076, 16954, 407, 1277, "Input",ExpressionUUID->"7ce042f1-6037-4f88-a70f-c8e8c38c471c",
 CellID->1132050647]
}, Closed]],
Cell[CellGroupData[{
Cell[101758, 2488, 380, 8, 44, "Subsubsection",ExpressionUUID->"e25a8672-0593-4acc-adb4-ae8a8bb6ca91"],
Cell[102141, 2498, 18004, 422, 1277, "Input",ExpressionUUID->"90f9a4f0-73bf-4520-973e-68bac1ae4c6e",
 CellID->1265603890]
}, Closed]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[120206, 2927, 174, 3, 106, "Section",ExpressionUUID->"4011ba50-2e74-4f6b-a674-877fc9ee6bb6"],
Cell[120383, 2932, 10701, 247, 627, "Input",ExpressionUUID->"072005b1-5989-4659-a0d6-5f475938cabc",
 CellID->1714140851]
}, Closed]],
Cell[CellGroupData[{
Cell[131121, 3184, 237, 5, 52, "Section",ExpressionUUID->"b76d2215-9a6c-4fac-8d58-8f22b53b9c8c"],
Cell[131361, 3191, 6669, 156, 429, "Input",ExpressionUUID->"30506a9a-cc1d-4ce3-8a4c-d982519503e8",
 CellID->1809561645]
}, Closed]],
Cell[CellGroupData[{
Cell[138067, 3352, 165, 3, 46, "Section",ExpressionUUID->"7a1b2f7d-cd66-48fe-9dc0-9849a48e7c0d"],
Cell[138235, 3357, 11164, 269, 989, "Input",ExpressionUUID->"7229f3b6-72df-44c8-91db-1e0fc105f733"],
Cell[149402, 3628, 15830, 395, 1397, "Input",ExpressionUUID->"43082122-638d-4e0e-abc8-4ae7084848b9"],
Cell[165235, 4025, 1608, 37, 90, "Input",ExpressionUUID->"9c9a73eb-21f6-4fd9-b902-e8bcb5dbd1b3"]
}, Closed]],
Cell[CellGroupData[{
Cell[166880, 4067, 161, 3, 46, "Section",ExpressionUUID->"72b28ec6-27c6-45d8-b35f-a94af010b35b"],
Cell[CellGroupData[{
Cell[167066, 4074, 156, 3, 43, "Subsubsection",ExpressionUUID->"9eb9ff97-7d42-488c-abf8-c793d73e07e9"],
Cell[167225, 4079, 1920, 48, 131, "Input",ExpressionUUID->"27ba352b-593c-4ba1-a036-628ed8cc2e6f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[169182, 4132, 179, 3, 43, "Subsubsection",ExpressionUUID->"1887ea8d-28d7-4fdc-b70c-3c72dbf89793"],
Cell[169364, 4137, 9957, 235, 744, "Input",ExpressionUUID->"79ec5f21-a164-4719-96f1-8ccc5e474759"],
Cell[179324, 4374, 540, 12, 70, "Input",ExpressionUUID->"a031a051-4322-4eec-9ba1-589d03a00995"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[179913, 4392, 187, 3, 46, "Section",ExpressionUUID->"013ca7d9-34ab-46de-88d1-1bd9c60e81af"],
Cell[180103, 4397, 6084, 146, 499, "Input",ExpressionUUID->"6eb830da-0fa7-4c31-962f-7c77847b1a78"],
Cell[186190, 4545, 3405, 84, 294, "Input",ExpressionUUID->"0ac1569b-fa44-46d0-a4b8-6f5baf317531"],
Cell[CellGroupData[{
Cell[189620, 4633, 208, 4, 29, "Input",ExpressionUUID->"af23cb1f-d424-4866-ace4-e420b68e676e"],
Cell[189831, 4639, 341, 7, 33, "Output",ExpressionUUID->"a15b007c-f9c2-45fb-9556-812ad6639da0"]
}, Open  ]]
}, Closed]]
}
]
*)

